/*
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *     Data In Motioni - initial API and implementation
 */
package org.gecko.mac.rental.impl;

import java.util.Date;

import org.eclipse.emf.common.notify.Notification;

import org.eclipse.emf.ecore.EClass;

import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.MinimalEObjectImpl;

import org.gecko.mac.rental.GolfRentalPackage;
import org.gecko.mac.rental.Rental;
import org.gecko.mac.rental.RentalStatus;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Rental</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link org.gecko.mac.rental.impl.RentalImpl#getId <em>Id</em>}</li>
 *   <li>{@link org.gecko.mac.rental.impl.RentalImpl#getEquipmentId <em>Equipment Id</em>}</li>
 *   <li>{@link org.gecko.mac.rental.impl.RentalImpl#getPlayerId <em>Player Id</em>}</li>
 *   <li>{@link org.gecko.mac.rental.impl.RentalImpl#getRentalStart <em>Rental Start</em>}</li>
 *   <li>{@link org.gecko.mac.rental.impl.RentalImpl#getRentalEnd <em>Rental End</em>}</li>
 *   <li>{@link org.gecko.mac.rental.impl.RentalImpl#getTotalCost <em>Total Cost</em>}</li>
 *   <li>{@link org.gecko.mac.rental.impl.RentalImpl#getStatus <em>Status</em>}</li>
 *   <li>{@link org.gecko.mac.rental.impl.RentalImpl#getTransactionId <em>Transaction Id</em>}</li>
 * </ul>
 *
 * @generated
 */
public class RentalImpl extends MinimalEObjectImpl.Container implements Rental {
	/**
	 * The default value of the '{@link #getId() <em>Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getId()
	 * @generated
	 * @ordered
	 */
	protected static final String ID_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getId() <em>Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getId()
	 * @generated
	 * @ordered
	 */
	protected String id = ID_EDEFAULT;

	/**
	 * The default value of the '{@link #getEquipmentId() <em>Equipment Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getEquipmentId()
	 * @generated
	 * @ordered
	 */
	protected static final String EQUIPMENT_ID_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getEquipmentId() <em>Equipment Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getEquipmentId()
	 * @generated
	 * @ordered
	 */
	protected String equipmentId = EQUIPMENT_ID_EDEFAULT;

	/**
	 * The default value of the '{@link #getPlayerId() <em>Player Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getPlayerId()
	 * @generated
	 * @ordered
	 */
	protected static final String PLAYER_ID_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getPlayerId() <em>Player Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getPlayerId()
	 * @generated
	 * @ordered
	 */
	protected String playerId = PLAYER_ID_EDEFAULT;

	/**
	 * The default value of the '{@link #getRentalStart() <em>Rental Start</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getRentalStart()
	 * @generated
	 * @ordered
	 */
	protected static final Date RENTAL_START_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getRentalStart() <em>Rental Start</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getRentalStart()
	 * @generated
	 * @ordered
	 */
	protected Date rentalStart = RENTAL_START_EDEFAULT;

	/**
	 * The default value of the '{@link #getRentalEnd() <em>Rental End</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getRentalEnd()
	 * @generated
	 * @ordered
	 */
	protected static final Date RENTAL_END_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getRentalEnd() <em>Rental End</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getRentalEnd()
	 * @generated
	 * @ordered
	 */
	protected Date rentalEnd = RENTAL_END_EDEFAULT;

	/**
	 * The default value of the '{@link #getTotalCost() <em>Total Cost</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTotalCost()
	 * @generated
	 * @ordered
	 */
	protected static final double TOTAL_COST_EDEFAULT = 0.0;

	/**
	 * The cached value of the '{@link #getTotalCost() <em>Total Cost</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTotalCost()
	 * @generated
	 * @ordered
	 */
	protected double totalCost = TOTAL_COST_EDEFAULT;

	/**
	 * The default value of the '{@link #getStatus() <em>Status</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getStatus()
	 * @generated
	 * @ordered
	 */
	protected static final RentalStatus STATUS_EDEFAULT = RentalStatus.ACTIVE;

	/**
	 * The cached value of the '{@link #getStatus() <em>Status</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getStatus()
	 * @generated
	 * @ordered
	 */
	protected RentalStatus status = STATUS_EDEFAULT;

	/**
	 * The default value of the '{@link #getTransactionId() <em>Transaction Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTransactionId()
	 * @generated
	 * @ordered
	 */
	protected static final String TRANSACTION_ID_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getTransactionId() <em>Transaction Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTransactionId()
	 * @generated
	 * @ordered
	 */
	protected String transactionId = TRANSACTION_ID_EDEFAULT;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected RentalImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return GolfRentalPackage.Literals.RENTAL;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getId() {
		return id;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setId(String newId) {
		String oldId = id;
		id = newId;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, GolfRentalPackage.RENTAL__ID, oldId, id));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getEquipmentId() {
		return equipmentId;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setEquipmentId(String newEquipmentId) {
		String oldEquipmentId = equipmentId;
		equipmentId = newEquipmentId;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, GolfRentalPackage.RENTAL__EQUIPMENT_ID, oldEquipmentId, equipmentId));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getPlayerId() {
		return playerId;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setPlayerId(String newPlayerId) {
		String oldPlayerId = playerId;
		playerId = newPlayerId;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, GolfRentalPackage.RENTAL__PLAYER_ID, oldPlayerId, playerId));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Date getRentalStart() {
		return rentalStart;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setRentalStart(Date newRentalStart) {
		Date oldRentalStart = rentalStart;
		rentalStart = newRentalStart;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, GolfRentalPackage.RENTAL__RENTAL_START, oldRentalStart, rentalStart));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Date getRentalEnd() {
		return rentalEnd;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setRentalEnd(Date newRentalEnd) {
		Date oldRentalEnd = rentalEnd;
		rentalEnd = newRentalEnd;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, GolfRentalPackage.RENTAL__RENTAL_END, oldRentalEnd, rentalEnd));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public double getTotalCost() {
		return totalCost;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setTotalCost(double newTotalCost) {
		double oldTotalCost = totalCost;
		totalCost = newTotalCost;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, GolfRentalPackage.RENTAL__TOTAL_COST, oldTotalCost, totalCost));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public RentalStatus getStatus() {
		return status;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setStatus(RentalStatus newStatus) {
		RentalStatus oldStatus = status;
		status = newStatus == null ? STATUS_EDEFAULT : newStatus;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, GolfRentalPackage.RENTAL__STATUS, oldStatus, status));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getTransactionId() {
		return transactionId;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setTransactionId(String newTransactionId) {
		String oldTransactionId = transactionId;
		transactionId = newTransactionId;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, GolfRentalPackage.RENTAL__TRANSACTION_ID, oldTransactionId, transactionId));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case GolfRentalPackage.RENTAL__ID:
				return getId();
			case GolfRentalPackage.RENTAL__EQUIPMENT_ID:
				return getEquipmentId();
			case GolfRentalPackage.RENTAL__PLAYER_ID:
				return getPlayerId();
			case GolfRentalPackage.RENTAL__RENTAL_START:
				return getRentalStart();
			case GolfRentalPackage.RENTAL__RENTAL_END:
				return getRentalEnd();
			case GolfRentalPackage.RENTAL__TOTAL_COST:
				return getTotalCost();
			case GolfRentalPackage.RENTAL__STATUS:
				return getStatus();
			case GolfRentalPackage.RENTAL__TRANSACTION_ID:
				return getTransactionId();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case GolfRentalPackage.RENTAL__ID:
				setId((String)newValue);
				return;
			case GolfRentalPackage.RENTAL__EQUIPMENT_ID:
				setEquipmentId((String)newValue);
				return;
			case GolfRentalPackage.RENTAL__PLAYER_ID:
				setPlayerId((String)newValue);
				return;
			case GolfRentalPackage.RENTAL__RENTAL_START:
				setRentalStart((Date)newValue);
				return;
			case GolfRentalPackage.RENTAL__RENTAL_END:
				setRentalEnd((Date)newValue);
				return;
			case GolfRentalPackage.RENTAL__TOTAL_COST:
				setTotalCost((Double)newValue);
				return;
			case GolfRentalPackage.RENTAL__STATUS:
				setStatus((RentalStatus)newValue);
				return;
			case GolfRentalPackage.RENTAL__TRANSACTION_ID:
				setTransactionId((String)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case GolfRentalPackage.RENTAL__ID:
				setId(ID_EDEFAULT);
				return;
			case GolfRentalPackage.RENTAL__EQUIPMENT_ID:
				setEquipmentId(EQUIPMENT_ID_EDEFAULT);
				return;
			case GolfRentalPackage.RENTAL__PLAYER_ID:
				setPlayerId(PLAYER_ID_EDEFAULT);
				return;
			case GolfRentalPackage.RENTAL__RENTAL_START:
				setRentalStart(RENTAL_START_EDEFAULT);
				return;
			case GolfRentalPackage.RENTAL__RENTAL_END:
				setRentalEnd(RENTAL_END_EDEFAULT);
				return;
			case GolfRentalPackage.RENTAL__TOTAL_COST:
				setTotalCost(TOTAL_COST_EDEFAULT);
				return;
			case GolfRentalPackage.RENTAL__STATUS:
				setStatus(STATUS_EDEFAULT);
				return;
			case GolfRentalPackage.RENTAL__TRANSACTION_ID:
				setTransactionId(TRANSACTION_ID_EDEFAULT);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case GolfRentalPackage.RENTAL__ID:
				return ID_EDEFAULT == null ? id != null : !ID_EDEFAULT.equals(id);
			case GolfRentalPackage.RENTAL__EQUIPMENT_ID:
				return EQUIPMENT_ID_EDEFAULT == null ? equipmentId != null : !EQUIPMENT_ID_EDEFAULT.equals(equipmentId);
			case GolfRentalPackage.RENTAL__PLAYER_ID:
				return PLAYER_ID_EDEFAULT == null ? playerId != null : !PLAYER_ID_EDEFAULT.equals(playerId);
			case GolfRentalPackage.RENTAL__RENTAL_START:
				return RENTAL_START_EDEFAULT == null ? rentalStart != null : !RENTAL_START_EDEFAULT.equals(rentalStart);
			case GolfRentalPackage.RENTAL__RENTAL_END:
				return RENTAL_END_EDEFAULT == null ? rentalEnd != null : !RENTAL_END_EDEFAULT.equals(rentalEnd);
			case GolfRentalPackage.RENTAL__TOTAL_COST:
				return totalCost != TOTAL_COST_EDEFAULT;
			case GolfRentalPackage.RENTAL__STATUS:
				return status != STATUS_EDEFAULT;
			case GolfRentalPackage.RENTAL__TRANSACTION_ID:
				return TRANSACTION_ID_EDEFAULT == null ? transactionId != null : !TRANSACTION_ID_EDEFAULT.equals(transactionId);
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuilder result = new StringBuilder(super.toString());
		result.append(" (id: ");
		result.append(id);
		result.append(", equipmentId: ");
		result.append(equipmentId);
		result.append(", playerId: ");
		result.append(playerId);
		result.append(", rentalStart: ");
		result.append(rentalStart);
		result.append(", rentalEnd: ");
		result.append(rentalEnd);
		result.append(", totalCost: ");
		result.append(totalCost);
		result.append(", status: ");
		result.append(status);
		result.append(", transactionId: ");
		result.append(transactionId);
		result.append(')');
		return result.toString();
	}

} //RentalImpl
