/*
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *     Data In Motioni - initial API and implementation
 */
package org.gecko.mac.transaction;

import java.util.Date;

import org.eclipse.emf.ecore.EObject;

import org.osgi.annotation.versioning.ProviderType;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Transaction</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link org.gecko.mac.transaction.Transaction#getId <em>Id</em>}</li>
 *   <li>{@link org.gecko.mac.transaction.Transaction#getPlayerId <em>Player Id</em>}</li>
 *   <li>{@link org.gecko.mac.transaction.Transaction#getTransuctionSubjectId <em>Transuction Subject Id</em>}</li>
 *   <li>{@link org.gecko.mac.transaction.Transaction#getTransactionDate <em>Transaction Date</em>}</li>
 *   <li>{@link org.gecko.mac.transaction.Transaction#getAmount <em>Amount</em>}</li>
 *   <li>{@link org.gecko.mac.transaction.Transaction#getType <em>Type</em>}</li>
 *   <li>{@link org.gecko.mac.transaction.Transaction#getPaymentMethod <em>Payment Method</em>}</li>
 * </ul>
 *
 * @see org.gecko.mac.transaction.GolfTransactionPackage#getTransaction()
 * @model
 * @generated
 */
@ProviderType
public interface Transaction extends EObject {
	/**
	 * Returns the value of the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Id</em>' attribute.
	 * @see #setId(String)
	 * @see org.gecko.mac.transaction.GolfTransactionPackage#getTransaction_Id()
	 * @model id="true" required="true"
	 * @generated
	 */
	String getId();

	/**
	 * Sets the value of the '{@link org.gecko.mac.transaction.Transaction#getId <em>Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Id</em>' attribute.
	 * @see #getId()
	 * @generated
	 */
	void setId(String value);

	/**
	 * Returns the value of the '<em><b>Player Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Player Id</em>' attribute.
	 * @see #setPlayerId(String)
	 * @see org.gecko.mac.transaction.GolfTransactionPackage#getTransaction_PlayerId()
	 * @model required="true"
	 * @generated
	 */
	String getPlayerId();

	/**
	 * Sets the value of the '{@link org.gecko.mac.transaction.Transaction#getPlayerId <em>Player Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Player Id</em>' attribute.
	 * @see #getPlayerId()
	 * @generated
	 */
	void setPlayerId(String value);

	/**
	 * Returns the value of the '<em><b>Transuction Subject Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Links to the specific source entity, such as a BookingID or RentalID.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Transuction Subject Id</em>' attribute.
	 * @see #setTransuctionSubjectId(String)
	 * @see org.gecko.mac.transaction.GolfTransactionPackage#getTransaction_TransuctionSubjectId()
	 * @model required="true"
	 * @generated
	 */
	String getTransuctionSubjectId();

	/**
	 * Sets the value of the '{@link org.gecko.mac.transaction.Transaction#getTransuctionSubjectId <em>Transuction Subject Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Transuction Subject Id</em>' attribute.
	 * @see #getTransuctionSubjectId()
	 * @generated
	 */
	void setTransuctionSubjectId(String value);

	/**
	 * Returns the value of the '<em><b>Transaction Date</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Transaction Date</em>' attribute.
	 * @see #setTransactionDate(Date)
	 * @see org.gecko.mac.transaction.GolfTransactionPackage#getTransaction_TransactionDate()
	 * @model
	 * @generated
	 */
	Date getTransactionDate();

	/**
	 * Sets the value of the '{@link org.gecko.mac.transaction.Transaction#getTransactionDate <em>Transaction Date</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Transaction Date</em>' attribute.
	 * @see #getTransactionDate()
	 * @generated
	 */
	void setTransactionDate(Date value);

	/**
	 * Returns the value of the '<em><b>Amount</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Amount</em>' attribute.
	 * @see #setAmount(double)
	 * @see org.gecko.mac.transaction.GolfTransactionPackage#getTransaction_Amount()
	 * @model
	 * @generated
	 */
	double getAmount();

	/**
	 * Sets the value of the '{@link org.gecko.mac.transaction.Transaction#getAmount <em>Amount</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Amount</em>' attribute.
	 * @see #getAmount()
	 * @generated
	 */
	void setAmount(double value);

	/**
	 * Returns the value of the '<em><b>Type</b></em>' attribute.
	 * The literals are from the enumeration {@link org.gecko.mac.transaction.TransactionType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Type</em>' attribute.
	 * @see org.gecko.mac.transaction.TransactionType
	 * @see #setType(TransactionType)
	 * @see org.gecko.mac.transaction.GolfTransactionPackage#getTransaction_Type()
	 * @model
	 * @generated
	 */
	TransactionType getType();

	/**
	 * Sets the value of the '{@link org.gecko.mac.transaction.Transaction#getType <em>Type</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Type</em>' attribute.
	 * @see org.gecko.mac.transaction.TransactionType
	 * @see #getType()
	 * @generated
	 */
	void setType(TransactionType value);

	/**
	 * Returns the value of the '<em><b>Payment Method</b></em>' attribute.
	 * The literals are from the enumeration {@link org.gecko.mac.transaction.PaymentMethod}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Payment Method</em>' attribute.
	 * @see org.gecko.mac.transaction.PaymentMethod
	 * @see #setPaymentMethod(PaymentMethod)
	 * @see org.gecko.mac.transaction.GolfTransactionPackage#getTransaction_PaymentMethod()
	 * @model
	 * @generated
	 */
	PaymentMethod getPaymentMethod();

	/**
	 * Sets the value of the '{@link org.gecko.mac.transaction.Transaction#getPaymentMethod <em>Payment Method</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Payment Method</em>' attribute.
	 * @see org.gecko.mac.transaction.PaymentMethod
	 * @see #getPaymentMethod()
	 * @generated
	 */
	void setPaymentMethod(PaymentMethod value);

} // Transaction
