/*
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *     Data In Motioni - initial API and implementation
 */
package org.gecko.mac.transaction.impl;

import java.util.Date;

import org.eclipse.emf.common.notify.Notification;

import org.eclipse.emf.ecore.EClass;

import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.MinimalEObjectImpl;

import org.gecko.mac.transaction.GolfTransactionPackage;
import org.gecko.mac.transaction.PaymentMethod;
import org.gecko.mac.transaction.Transaction;
import org.gecko.mac.transaction.TransactionType;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Transaction</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link org.gecko.mac.transaction.impl.TransactionImpl#getId <em>Id</em>}</li>
 *   <li>{@link org.gecko.mac.transaction.impl.TransactionImpl#getPlayerId <em>Player Id</em>}</li>
 *   <li>{@link org.gecko.mac.transaction.impl.TransactionImpl#getTransuctionSubjectId <em>Transuction Subject Id</em>}</li>
 *   <li>{@link org.gecko.mac.transaction.impl.TransactionImpl#getTransactionDate <em>Transaction Date</em>}</li>
 *   <li>{@link org.gecko.mac.transaction.impl.TransactionImpl#getAmount <em>Amount</em>}</li>
 *   <li>{@link org.gecko.mac.transaction.impl.TransactionImpl#getType <em>Type</em>}</li>
 *   <li>{@link org.gecko.mac.transaction.impl.TransactionImpl#getPaymentMethod <em>Payment Method</em>}</li>
 * </ul>
 *
 * @generated
 */
public class TransactionImpl extends MinimalEObjectImpl.Container implements Transaction {
	/**
	 * The default value of the '{@link #getId() <em>Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getId()
	 * @generated
	 * @ordered
	 */
	protected static final String ID_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getId() <em>Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getId()
	 * @generated
	 * @ordered
	 */
	protected String id = ID_EDEFAULT;

	/**
	 * The default value of the '{@link #getPlayerId() <em>Player Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getPlayerId()
	 * @generated
	 * @ordered
	 */
	protected static final String PLAYER_ID_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getPlayerId() <em>Player Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getPlayerId()
	 * @generated
	 * @ordered
	 */
	protected String playerId = PLAYER_ID_EDEFAULT;

	/**
	 * The default value of the '{@link #getTransuctionSubjectId() <em>Transuction Subject Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTransuctionSubjectId()
	 * @generated
	 * @ordered
	 */
	protected static final String TRANSUCTION_SUBJECT_ID_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getTransuctionSubjectId() <em>Transuction Subject Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTransuctionSubjectId()
	 * @generated
	 * @ordered
	 */
	protected String transuctionSubjectId = TRANSUCTION_SUBJECT_ID_EDEFAULT;

	/**
	 * The default value of the '{@link #getTransactionDate() <em>Transaction Date</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTransactionDate()
	 * @generated
	 * @ordered
	 */
	protected static final Date TRANSACTION_DATE_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getTransactionDate() <em>Transaction Date</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTransactionDate()
	 * @generated
	 * @ordered
	 */
	protected Date transactionDate = TRANSACTION_DATE_EDEFAULT;

	/**
	 * The default value of the '{@link #getAmount() <em>Amount</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getAmount()
	 * @generated
	 * @ordered
	 */
	protected static final double AMOUNT_EDEFAULT = 0.0;

	/**
	 * The cached value of the '{@link #getAmount() <em>Amount</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getAmount()
	 * @generated
	 * @ordered
	 */
	protected double amount = AMOUNT_EDEFAULT;

	/**
	 * The default value of the '{@link #getType() <em>Type</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getType()
	 * @generated
	 * @ordered
	 */
	protected static final TransactionType TYPE_EDEFAULT = TransactionType.BOOKING_FEE;

	/**
	 * The cached value of the '{@link #getType() <em>Type</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getType()
	 * @generated
	 * @ordered
	 */
	protected TransactionType type = TYPE_EDEFAULT;

	/**
	 * The default value of the '{@link #getPaymentMethod() <em>Payment Method</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getPaymentMethod()
	 * @generated
	 * @ordered
	 */
	protected static final PaymentMethod PAYMENT_METHOD_EDEFAULT = PaymentMethod.CREDIT_CARD;

	/**
	 * The cached value of the '{@link #getPaymentMethod() <em>Payment Method</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getPaymentMethod()
	 * @generated
	 * @ordered
	 */
	protected PaymentMethod paymentMethod = PAYMENT_METHOD_EDEFAULT;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TransactionImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return GolfTransactionPackage.Literals.TRANSACTION;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getId() {
		return id;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setId(String newId) {
		String oldId = id;
		id = newId;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, GolfTransactionPackage.TRANSACTION__ID, oldId, id));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getPlayerId() {
		return playerId;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setPlayerId(String newPlayerId) {
		String oldPlayerId = playerId;
		playerId = newPlayerId;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, GolfTransactionPackage.TRANSACTION__PLAYER_ID, oldPlayerId, playerId));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getTransuctionSubjectId() {
		return transuctionSubjectId;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setTransuctionSubjectId(String newTransuctionSubjectId) {
		String oldTransuctionSubjectId = transuctionSubjectId;
		transuctionSubjectId = newTransuctionSubjectId;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, GolfTransactionPackage.TRANSACTION__TRANSUCTION_SUBJECT_ID, oldTransuctionSubjectId, transuctionSubjectId));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Date getTransactionDate() {
		return transactionDate;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setTransactionDate(Date newTransactionDate) {
		Date oldTransactionDate = transactionDate;
		transactionDate = newTransactionDate;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, GolfTransactionPackage.TRANSACTION__TRANSACTION_DATE, oldTransactionDate, transactionDate));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public double getAmount() {
		return amount;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setAmount(double newAmount) {
		double oldAmount = amount;
		amount = newAmount;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, GolfTransactionPackage.TRANSACTION__AMOUNT, oldAmount, amount));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public TransactionType getType() {
		return type;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setType(TransactionType newType) {
		TransactionType oldType = type;
		type = newType == null ? TYPE_EDEFAULT : newType;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, GolfTransactionPackage.TRANSACTION__TYPE, oldType, type));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public PaymentMethod getPaymentMethod() {
		return paymentMethod;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setPaymentMethod(PaymentMethod newPaymentMethod) {
		PaymentMethod oldPaymentMethod = paymentMethod;
		paymentMethod = newPaymentMethod == null ? PAYMENT_METHOD_EDEFAULT : newPaymentMethod;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, GolfTransactionPackage.TRANSACTION__PAYMENT_METHOD, oldPaymentMethod, paymentMethod));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case GolfTransactionPackage.TRANSACTION__ID:
				return getId();
			case GolfTransactionPackage.TRANSACTION__PLAYER_ID:
				return getPlayerId();
			case GolfTransactionPackage.TRANSACTION__TRANSUCTION_SUBJECT_ID:
				return getTransuctionSubjectId();
			case GolfTransactionPackage.TRANSACTION__TRANSACTION_DATE:
				return getTransactionDate();
			case GolfTransactionPackage.TRANSACTION__AMOUNT:
				return getAmount();
			case GolfTransactionPackage.TRANSACTION__TYPE:
				return getType();
			case GolfTransactionPackage.TRANSACTION__PAYMENT_METHOD:
				return getPaymentMethod();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case GolfTransactionPackage.TRANSACTION__ID:
				setId((String)newValue);
				return;
			case GolfTransactionPackage.TRANSACTION__PLAYER_ID:
				setPlayerId((String)newValue);
				return;
			case GolfTransactionPackage.TRANSACTION__TRANSUCTION_SUBJECT_ID:
				setTransuctionSubjectId((String)newValue);
				return;
			case GolfTransactionPackage.TRANSACTION__TRANSACTION_DATE:
				setTransactionDate((Date)newValue);
				return;
			case GolfTransactionPackage.TRANSACTION__AMOUNT:
				setAmount((Double)newValue);
				return;
			case GolfTransactionPackage.TRANSACTION__TYPE:
				setType((TransactionType)newValue);
				return;
			case GolfTransactionPackage.TRANSACTION__PAYMENT_METHOD:
				setPaymentMethod((PaymentMethod)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case GolfTransactionPackage.TRANSACTION__ID:
				setId(ID_EDEFAULT);
				return;
			case GolfTransactionPackage.TRANSACTION__PLAYER_ID:
				setPlayerId(PLAYER_ID_EDEFAULT);
				return;
			case GolfTransactionPackage.TRANSACTION__TRANSUCTION_SUBJECT_ID:
				setTransuctionSubjectId(TRANSUCTION_SUBJECT_ID_EDEFAULT);
				return;
			case GolfTransactionPackage.TRANSACTION__TRANSACTION_DATE:
				setTransactionDate(TRANSACTION_DATE_EDEFAULT);
				return;
			case GolfTransactionPackage.TRANSACTION__AMOUNT:
				setAmount(AMOUNT_EDEFAULT);
				return;
			case GolfTransactionPackage.TRANSACTION__TYPE:
				setType(TYPE_EDEFAULT);
				return;
			case GolfTransactionPackage.TRANSACTION__PAYMENT_METHOD:
				setPaymentMethod(PAYMENT_METHOD_EDEFAULT);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case GolfTransactionPackage.TRANSACTION__ID:
				return ID_EDEFAULT == null ? id != null : !ID_EDEFAULT.equals(id);
			case GolfTransactionPackage.TRANSACTION__PLAYER_ID:
				return PLAYER_ID_EDEFAULT == null ? playerId != null : !PLAYER_ID_EDEFAULT.equals(playerId);
			case GolfTransactionPackage.TRANSACTION__TRANSUCTION_SUBJECT_ID:
				return TRANSUCTION_SUBJECT_ID_EDEFAULT == null ? transuctionSubjectId != null : !TRANSUCTION_SUBJECT_ID_EDEFAULT.equals(transuctionSubjectId);
			case GolfTransactionPackage.TRANSACTION__TRANSACTION_DATE:
				return TRANSACTION_DATE_EDEFAULT == null ? transactionDate != null : !TRANSACTION_DATE_EDEFAULT.equals(transactionDate);
			case GolfTransactionPackage.TRANSACTION__AMOUNT:
				return amount != AMOUNT_EDEFAULT;
			case GolfTransactionPackage.TRANSACTION__TYPE:
				return type != TYPE_EDEFAULT;
			case GolfTransactionPackage.TRANSACTION__PAYMENT_METHOD:
				return paymentMethod != PAYMENT_METHOD_EDEFAULT;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuilder result = new StringBuilder(super.toString());
		result.append(" (id: ");
		result.append(id);
		result.append(", playerId: ");
		result.append(playerId);
		result.append(", transuctionSubjectId: ");
		result.append(transuctionSubjectId);
		result.append(", transactionDate: ");
		result.append(transactionDate);
		result.append(", amount: ");
		result.append(amount);
		result.append(", type: ");
		result.append(type);
		result.append(", paymentMethod: ");
		result.append(paymentMethod);
		result.append(')');
		return result.toString();
	}

} //TransactionImpl
