/*
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *      Mark Hoffmann - initial API and implementation
 */
package org.gecko.mac.lorawan.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.MinimalEObjectImpl;

import org.gecko.mac.lorawan.LoRaWANPackage;
import org.gecko.mac.lorawan.LoraInfo;
import org.gecko.mac.lorawan.Modulation;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Modulation</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link org.gecko.mac.lorawan.impl.ModulationImpl#getLora <em>Lora</em>}</li>
 * </ul>
 *
 * @generated
 */
public class ModulationImpl extends MinimalEObjectImpl.Container implements Modulation {
	/**
	 * The cached value of the '{@link #getLora() <em>Lora</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getLora()
	 * @generated
	 * @ordered
	 */
	protected LoraInfo lora;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ModulationImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return LoRaWANPackage.Literals.MODULATION;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public LoraInfo getLora() {
		return lora;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetLora(LoraInfo newLora, NotificationChain msgs) {
		LoraInfo oldLora = lora;
		lora = newLora;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, LoRaWANPackage.MODULATION__LORA, oldLora, newLora);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setLora(LoraInfo newLora) {
		if (newLora != lora) {
			NotificationChain msgs = null;
			if (lora != null)
				msgs = ((InternalEObject)lora).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - LoRaWANPackage.MODULATION__LORA, null, msgs);
			if (newLora != null)
				msgs = ((InternalEObject)newLora).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - LoRaWANPackage.MODULATION__LORA, null, msgs);
			msgs = basicSetLora(newLora, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, LoRaWANPackage.MODULATION__LORA, newLora, newLora));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case LoRaWANPackage.MODULATION__LORA:
				return basicSetLora(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case LoRaWANPackage.MODULATION__LORA:
				return getLora();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case LoRaWANPackage.MODULATION__LORA:
				setLora((LoraInfo)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case LoRaWANPackage.MODULATION__LORA:
				setLora((LoraInfo)null);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case LoRaWANPackage.MODULATION__LORA:
				return lora != null;
		}
		return super.eIsSet(featureID);
	}

} //ModulationImpl
