/*
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *      Data In Motion - initial API and implementation
 */
package org.gecko.mac.moisture;

import org.eclipse.emf.ecore.EObject;

import org.osgi.annotation.versioning.ProviderType;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Calibration Data</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * Calibration reference values for converting raw ADC readings to percentage
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link org.gecko.mac.moisture.CalibrationData#getDry <em>Dry</em>}</li>
 *   <li>{@link org.gecko.mac.moisture.CalibrationData#getWet <em>Wet</em>}</li>
 * </ul>
 *
 * @see org.gecko.mac.moisture.MoisturePackage#getCalibrationData()
 * @model
 * @generated
 */
@ProviderType
public interface CalibrationData extends EObject {
	/**
	 * Returns the value of the '<em><b>Dry</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Raw ADC value for completely dry soil (0% moisture)
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Dry</em>' attribute.
	 * @see #setDry(int)
	 * @see org.gecko.mac.moisture.MoisturePackage#getCalibrationData_Dry()
	 * @model
	 * @generated
	 */
	int getDry();

	/**
	 * Sets the value of the '{@link org.gecko.mac.moisture.CalibrationData#getDry <em>Dry</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Dry</em>' attribute.
	 * @see #getDry()
	 * @generated
	 */
	void setDry(int value);

	/**
	 * Returns the value of the '<em><b>Wet</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Raw ADC value for completely wet soil (100% moisture)
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Wet</em>' attribute.
	 * @see #setWet(int)
	 * @see org.gecko.mac.moisture.MoisturePackage#getCalibrationData_Wet()
	 * @model
	 * @generated
	 */
	int getWet();

	/**
	 * Sets the value of the '{@link org.gecko.mac.moisture.CalibrationData#getWet <em>Wet</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Wet</em>' attribute.
	 * @see #getWet()
	 * @generated
	 */
	void setWet(int value);

} // CalibrationData
