/*
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *      Data In Motion - initial API and implementation
 */
package org.gecko.mac.moisture;

import org.gecko.mac.lorawan.UplinkMessage;

import org.osgi.annotation.versioning.ProviderType;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>M5 Moisture Uplink</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link org.gecko.mac.moisture.M5MoistureUplink#getObject <em>Object</em>}</li>
 * </ul>
 *
 * @see org.gecko.mac.moisture.MoisturePackage#getM5MoistureUplink()
 * @model annotation="codec.type value='M5 Moisture v1'"
 * @generated
 */
@ProviderType
public interface M5MoistureUplink extends UplinkMessage {
	/**
	 * Returns the value of the '<em><b>Object</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Decoded sensor payload containing moisture readings and calibration data
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Object</em>' containment reference.
	 * @see #setObject(MoistureSensorData)
	 * @see org.gecko.mac.moisture.MoisturePackage#getM5MoistureUplink_Object()
	 * @model containment="true" required="true"
	 * @generated
	 */
	MoistureSensorData getObject();

	/**
	 * Sets the value of the '{@link org.gecko.mac.moisture.M5MoistureUplink#getObject <em>Object</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Object</em>' containment reference.
	 * @see #getObject()
	 * @generated
	 */
	void setObject(MoistureSensorData value);

} // M5MoistureUplink
