/*
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *      Data In Motion - initial API and implementation
 */
package org.gecko.mac.moisture;


import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EReference;

import org.gecko.emf.osgi.annotation.provide.EPackage;

import org.gecko.mac.lorawan.LoRaWANPackage;

import org.osgi.annotation.versioning.ProviderType;

/**
 * <!-- begin-user-doc -->
 * The <b>Package</b> for the model.
 * It contains accessors for the meta objects to represent
 * <ul>
 *   <li>each class,</li>
 *   <li>each feature of each class,</li>
 *   <li>each operation of each class,</li>
 *   <li>each enum,</li>
 *   <li>and each data type</li>
 * </ul>
 * <!-- end-user-doc -->
 * @see org.gecko.mac.moisture.MoistureFactory
 * @model kind="package"
 *        annotation="Version value='1.0'"
 *        annotation="http://www.eclipse.org/emf/2002/GenModel modelName='Moisture' complianceLevel='21.0' copyrightText='Copyright (c) 2012 - 2025 Data In Motion and others.\nAll rights reserved.\n\nThis program and the accompanying materials are made\navailable under the terms of the Eclipse Public License 2.0\nwhich is available at https://www.eclipse.org/legal/epl-2.0/\n\nSPDX-License-Identifier: EPL-2.0\n\nContributors:\n     Data In Motion - initial API and implementation' resource='XMI' oSGiCompatible='true' prefix='Moisture' basePackage='org.gecko.mac'"
 * @generated
 */
@ProviderType
@EPackage(uri = MoisturePackage.eNS_URI, genModel = "/model/moisture.genmodel", genModelSourceLocations = {"model/moisture.genmodel","org.gecko.mac.moisture.model/model/moisture.genmodel"}, ecore="/model/moisture.ecore", ecoreSourceLocations="/model/moisture.ecore")
public interface MoisturePackage extends org.eclipse.emf.ecore.EPackage {
	/**
	 * The package name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNAME = "moisture";

	/**
	 * The package namespace URI.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_URI = "http://datainmotion.com/mac/moisture/1.0.0";

	/**
	 * The package namespace name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_PREFIX = "moisture";

	/**
	 * The singleton instance of the package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	MoisturePackage eINSTANCE = org.gecko.mac.moisture.impl.MoisturePackageImpl.init();

	/**
	 * The meta object id for the '{@link org.gecko.mac.moisture.impl.M5MoistureUplinkImpl <em>M5 Moisture Uplink</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.gecko.mac.moisture.impl.M5MoistureUplinkImpl
	 * @see org.gecko.mac.moisture.impl.MoisturePackageImpl#getM5MoistureUplink()
	 * @generated
	 */
	int M5_MOISTURE_UPLINK = 0;

	/**
	 * The feature id for the '<em><b>Deduplication Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int M5_MOISTURE_UPLINK__DEDUPLICATION_ID = LoRaWANPackage.UPLINK_MESSAGE__DEDUPLICATION_ID;

	/**
	 * The feature id for the '<em><b>Time</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int M5_MOISTURE_UPLINK__TIME = LoRaWANPackage.UPLINK_MESSAGE__TIME;

	/**
	 * The feature id for the '<em><b>Adr</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int M5_MOISTURE_UPLINK__ADR = LoRaWANPackage.UPLINK_MESSAGE__ADR;

	/**
	 * The feature id for the '<em><b>Dr</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int M5_MOISTURE_UPLINK__DR = LoRaWANPackage.UPLINK_MESSAGE__DR;

	/**
	 * The feature id for the '<em><b>FCnt</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int M5_MOISTURE_UPLINK__FCNT = LoRaWANPackage.UPLINK_MESSAGE__FCNT;

	/**
	 * The feature id for the '<em><b>FPort</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int M5_MOISTURE_UPLINK__FPORT = LoRaWANPackage.UPLINK_MESSAGE__FPORT;

	/**
	 * The feature id for the '<em><b>Confirmed</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int M5_MOISTURE_UPLINK__CONFIRMED = LoRaWANPackage.UPLINK_MESSAGE__CONFIRMED;

	/**
	 * The feature id for the '<em><b>Data</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int M5_MOISTURE_UPLINK__DATA = LoRaWANPackage.UPLINK_MESSAGE__DATA;

	/**
	 * The feature id for the '<em><b>Device Info</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int M5_MOISTURE_UPLINK__DEVICE_INFO = LoRaWANPackage.UPLINK_MESSAGE__DEVICE_INFO;

	/**
	 * The feature id for the '<em><b>Rx Info</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int M5_MOISTURE_UPLINK__RX_INFO = LoRaWANPackage.UPLINK_MESSAGE__RX_INFO;

	/**
	 * The feature id for the '<em><b>Dev Addr</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int M5_MOISTURE_UPLINK__DEV_ADDR = LoRaWANPackage.UPLINK_MESSAGE__DEV_ADDR;

	/**
	 * The feature id for the '<em><b>Tx Info</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int M5_MOISTURE_UPLINK__TX_INFO = LoRaWANPackage.UPLINK_MESSAGE__TX_INFO;

	/**
	 * The feature id for the '<em><b>Object</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int M5_MOISTURE_UPLINK__OBJECT = LoRaWANPackage.UPLINK_MESSAGE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>M5 Moisture Uplink</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int M5_MOISTURE_UPLINK_FEATURE_COUNT = LoRaWANPackage.UPLINK_MESSAGE_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>M5 Moisture Uplink</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int M5_MOISTURE_UPLINK_OPERATION_COUNT = LoRaWANPackage.UPLINK_MESSAGE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.gecko.mac.moisture.impl.MoistureSensorDataImpl <em>Sensor Data</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.gecko.mac.moisture.impl.MoistureSensorDataImpl
	 * @see org.gecko.mac.moisture.impl.MoisturePackageImpl#getMoistureSensorData()
	 * @generated
	 */
	int MOISTURE_SENSOR_DATA = 1;

	/**
	 * The feature id for the '<em><b>Moisture</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MOISTURE_SENSOR_DATA__MOISTURE = 0;

	/**
	 * The feature id for the '<em><b>Cal</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MOISTURE_SENSOR_DATA__CAL = 1;

	/**
	 * The feature id for the '<em><b>Timestamp</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MOISTURE_SENSOR_DATA__TIMESTAMP = 2;

	/**
	 * The number of structural features of the '<em>Sensor Data</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MOISTURE_SENSOR_DATA_FEATURE_COUNT = 3;

	/**
	 * The number of operations of the '<em>Sensor Data</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MOISTURE_SENSOR_DATA_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.gecko.mac.moisture.impl.MoistureReadingImpl <em>Reading</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.gecko.mac.moisture.impl.MoistureReadingImpl
	 * @see org.gecko.mac.moisture.impl.MoisturePackageImpl#getMoistureReading()
	 * @generated
	 */
	int MOISTURE_READING = 2;

	/**
	 * The feature id for the '<em><b>Percent</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MOISTURE_READING__PERCENT = 0;

	/**
	 * The feature id for the '<em><b>Raw</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MOISTURE_READING__RAW = 1;

	/**
	 * The number of structural features of the '<em>Reading</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MOISTURE_READING_FEATURE_COUNT = 2;

	/**
	 * The number of operations of the '<em>Reading</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MOISTURE_READING_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.gecko.mac.moisture.impl.CalibrationDataImpl <em>Calibration Data</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.gecko.mac.moisture.impl.CalibrationDataImpl
	 * @see org.gecko.mac.moisture.impl.MoisturePackageImpl#getCalibrationData()
	 * @generated
	 */
	int CALIBRATION_DATA = 3;

	/**
	 * The feature id for the '<em><b>Dry</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CALIBRATION_DATA__DRY = 0;

	/**
	 * The feature id for the '<em><b>Wet</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CALIBRATION_DATA__WET = 1;

	/**
	 * The number of structural features of the '<em>Calibration Data</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CALIBRATION_DATA_FEATURE_COUNT = 2;

	/**
	 * The number of operations of the '<em>Calibration Data</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CALIBRATION_DATA_OPERATION_COUNT = 0;


	/**
	 * Returns the meta object for class '{@link org.gecko.mac.moisture.M5MoistureUplink <em>M5 Moisture Uplink</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>M5 Moisture Uplink</em>'.
	 * @see org.gecko.mac.moisture.M5MoistureUplink
	 * @generated
	 */
	EClass getM5MoistureUplink();

	/**
	 * Returns the meta object for the containment reference '{@link org.gecko.mac.moisture.M5MoistureUplink#getObject <em>Object</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Object</em>'.
	 * @see org.gecko.mac.moisture.M5MoistureUplink#getObject()
	 * @see #getM5MoistureUplink()
	 * @generated
	 */
	EReference getM5MoistureUplink_Object();

	/**
	 * Returns the meta object for class '{@link org.gecko.mac.moisture.MoistureSensorData <em>Sensor Data</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Sensor Data</em>'.
	 * @see org.gecko.mac.moisture.MoistureSensorData
	 * @generated
	 */
	EClass getMoistureSensorData();

	/**
	 * Returns the meta object for the containment reference '{@link org.gecko.mac.moisture.MoistureSensorData#getMoisture <em>Moisture</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Moisture</em>'.
	 * @see org.gecko.mac.moisture.MoistureSensorData#getMoisture()
	 * @see #getMoistureSensorData()
	 * @generated
	 */
	EReference getMoistureSensorData_Moisture();

	/**
	 * Returns the meta object for the containment reference '{@link org.gecko.mac.moisture.MoistureSensorData#getCal <em>Cal</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Cal</em>'.
	 * @see org.gecko.mac.moisture.MoistureSensorData#getCal()
	 * @see #getMoistureSensorData()
	 * @generated
	 */
	EReference getMoistureSensorData_Cal();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.mac.moisture.MoistureSensorData#getTimestamp <em>Timestamp</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Timestamp</em>'.
	 * @see org.gecko.mac.moisture.MoistureSensorData#getTimestamp()
	 * @see #getMoistureSensorData()
	 * @generated
	 */
	EAttribute getMoistureSensorData_Timestamp();

	/**
	 * Returns the meta object for class '{@link org.gecko.mac.moisture.MoistureReading <em>Reading</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Reading</em>'.
	 * @see org.gecko.mac.moisture.MoistureReading
	 * @generated
	 */
	EClass getMoistureReading();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.mac.moisture.MoistureReading#getPercent <em>Percent</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Percent</em>'.
	 * @see org.gecko.mac.moisture.MoistureReading#getPercent()
	 * @see #getMoistureReading()
	 * @generated
	 */
	EAttribute getMoistureReading_Percent();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.mac.moisture.MoistureReading#getRaw <em>Raw</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Raw</em>'.
	 * @see org.gecko.mac.moisture.MoistureReading#getRaw()
	 * @see #getMoistureReading()
	 * @generated
	 */
	EAttribute getMoistureReading_Raw();

	/**
	 * Returns the meta object for class '{@link org.gecko.mac.moisture.CalibrationData <em>Calibration Data</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Calibration Data</em>'.
	 * @see org.gecko.mac.moisture.CalibrationData
	 * @generated
	 */
	EClass getCalibrationData();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.mac.moisture.CalibrationData#getDry <em>Dry</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Dry</em>'.
	 * @see org.gecko.mac.moisture.CalibrationData#getDry()
	 * @see #getCalibrationData()
	 * @generated
	 */
	EAttribute getCalibrationData_Dry();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.mac.moisture.CalibrationData#getWet <em>Wet</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Wet</em>'.
	 * @see org.gecko.mac.moisture.CalibrationData#getWet()
	 * @see #getCalibrationData()
	 * @generated
	 */
	EAttribute getCalibrationData_Wet();

	/**
	 * Returns the factory that creates the instances of the model.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the factory that creates the instances of the model.
	 * @generated
	 */
	MoistureFactory getMoistureFactory();

	/**
	 * <!-- begin-user-doc -->
	 * Defines literals for the meta objects that represent
	 * <ul>
	 *   <li>each class,</li>
	 *   <li>each feature of each class,</li>
	 *   <li>each operation of each class,</li>
	 *   <li>each enum,</li>
	 *   <li>and each data type</li>
	 * </ul>
	 * <!-- end-user-doc -->
	 * @generated
	 */
	interface Literals {
		/**
		 * The meta object literal for the '{@link org.gecko.mac.moisture.impl.M5MoistureUplinkImpl <em>M5 Moisture Uplink</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.gecko.mac.moisture.impl.M5MoistureUplinkImpl
		 * @see org.gecko.mac.moisture.impl.MoisturePackageImpl#getM5MoistureUplink()
		 * @generated
		 */
		EClass M5_MOISTURE_UPLINK = eINSTANCE.getM5MoistureUplink();

		/**
		 * The meta object literal for the '<em><b>Object</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference M5_MOISTURE_UPLINK__OBJECT = eINSTANCE.getM5MoistureUplink_Object();

		/**
		 * The meta object literal for the '{@link org.gecko.mac.moisture.impl.MoistureSensorDataImpl <em>Sensor Data</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.gecko.mac.moisture.impl.MoistureSensorDataImpl
		 * @see org.gecko.mac.moisture.impl.MoisturePackageImpl#getMoistureSensorData()
		 * @generated
		 */
		EClass MOISTURE_SENSOR_DATA = eINSTANCE.getMoistureSensorData();

		/**
		 * The meta object literal for the '<em><b>Moisture</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference MOISTURE_SENSOR_DATA__MOISTURE = eINSTANCE.getMoistureSensorData_Moisture();

		/**
		 * The meta object literal for the '<em><b>Cal</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference MOISTURE_SENSOR_DATA__CAL = eINSTANCE.getMoistureSensorData_Cal();

		/**
		 * The meta object literal for the '<em><b>Timestamp</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute MOISTURE_SENSOR_DATA__TIMESTAMP = eINSTANCE.getMoistureSensorData_Timestamp();

		/**
		 * The meta object literal for the '{@link org.gecko.mac.moisture.impl.MoistureReadingImpl <em>Reading</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.gecko.mac.moisture.impl.MoistureReadingImpl
		 * @see org.gecko.mac.moisture.impl.MoisturePackageImpl#getMoistureReading()
		 * @generated
		 */
		EClass MOISTURE_READING = eINSTANCE.getMoistureReading();

		/**
		 * The meta object literal for the '<em><b>Percent</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute MOISTURE_READING__PERCENT = eINSTANCE.getMoistureReading_Percent();

		/**
		 * The meta object literal for the '<em><b>Raw</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute MOISTURE_READING__RAW = eINSTANCE.getMoistureReading_Raw();

		/**
		 * The meta object literal for the '{@link org.gecko.mac.moisture.impl.CalibrationDataImpl <em>Calibration Data</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.gecko.mac.moisture.impl.CalibrationDataImpl
		 * @see org.gecko.mac.moisture.impl.MoisturePackageImpl#getCalibrationData()
		 * @generated
		 */
		EClass CALIBRATION_DATA = eINSTANCE.getCalibrationData();

		/**
		 * The meta object literal for the '<em><b>Dry</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute CALIBRATION_DATA__DRY = eINSTANCE.getCalibrationData_Dry();

		/**
		 * The meta object literal for the '<em><b>Wet</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute CALIBRATION_DATA__WET = eINSTANCE.getCalibrationData_Wet();

	}

} //MoisturePackage
