/*
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *      Data In Motion - initial API and implementation
 */
package org.gecko.mac.moisture;

import org.eclipse.emf.ecore.EObject;

import org.osgi.annotation.versioning.ProviderType;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Reading</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * Moisture measurement data with calibrated percentage and raw ADC value
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link org.gecko.mac.moisture.MoistureReading#getPercent <em>Percent</em>}</li>
 *   <li>{@link org.gecko.mac.moisture.MoistureReading#getRaw <em>Raw</em>}</li>
 * </ul>
 *
 * @see org.gecko.mac.moisture.MoisturePackage#getMoistureReading()
 * @model
 * @generated
 */
@ProviderType
public interface MoistureReading extends EObject {
	/**
	 * Returns the value of the '<em><b>Percent</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Calibrated moisture percentage (0-100%)
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Percent</em>' attribute.
	 * @see #setPercent(int)
	 * @see org.gecko.mac.moisture.MoisturePackage#getMoistureReading_Percent()
	 * @model
	 * @generated
	 */
	int getPercent();

	/**
	 * Sets the value of the '{@link org.gecko.mac.moisture.MoistureReading#getPercent <em>Percent</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Percent</em>' attribute.
	 * @see #getPercent()
	 * @generated
	 */
	void setPercent(int value);

	/**
	 * Returns the value of the '<em><b>Raw</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Raw ADC reading from moisture sensor
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Raw</em>' attribute.
	 * @see #setRaw(int)
	 * @see org.gecko.mac.moisture.MoisturePackage#getMoistureReading_Raw()
	 * @model
	 * @generated
	 */
	int getRaw();

	/**
	 * Sets the value of the '{@link org.gecko.mac.moisture.MoistureReading#getRaw <em>Raw</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Raw</em>' attribute.
	 * @see #getRaw()
	 * @generated
	 */
	void setRaw(int value);

} // MoistureReading
