/**
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *      Data In Motion - initial API and implementation
 */
package org.gecko.mac.moisture.impl;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;

import org.eclipse.emf.ecore.impl.EFactoryImpl;

import org.eclipse.emf.ecore.plugin.EcorePlugin;

import org.gecko.mac.moisture.*;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model <b>Factory</b>.
 * <!-- end-user-doc -->
 * @generated
 */
public class MoistureFactoryImpl extends EFactoryImpl implements MoistureFactory {
	/**
	 * Creates the default factory implementation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static MoistureFactory init() {
		try {
			MoistureFactory theMoistureFactory = (MoistureFactory)EPackage.Registry.INSTANCE.getEFactory(MoisturePackage.eNS_URI);
			if (theMoistureFactory != null) {
				return theMoistureFactory;
			}
		}
		catch (Exception exception) {
			EcorePlugin.INSTANCE.log(exception);
		}
		return new MoistureFactoryImpl();
	}

	/**
	 * Creates an instance of the factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public MoistureFactoryImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EObject create(EClass eClass) {
		switch (eClass.getClassifierID()) {
			case MoisturePackage.M5_MOISTURE_UPLINK: return createM5MoistureUplink();
			case MoisturePackage.MOISTURE_SENSOR_DATA: return createMoistureSensorData();
			case MoisturePackage.MOISTURE_READING: return createMoistureReading();
			case MoisturePackage.CALIBRATION_DATA: return createCalibrationData();
			default:
				throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public M5MoistureUplink createM5MoistureUplink() {
		M5MoistureUplinkImpl m5MoistureUplink = new M5MoistureUplinkImpl();
		return m5MoistureUplink;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public MoistureSensorData createMoistureSensorData() {
		MoistureSensorDataImpl moistureSensorData = new MoistureSensorDataImpl();
		return moistureSensorData;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public MoistureReading createMoistureReading() {
		MoistureReadingImpl moistureReading = new MoistureReadingImpl();
		return moistureReading;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public CalibrationData createCalibrationData() {
		CalibrationDataImpl calibrationData = new CalibrationDataImpl();
		return calibrationData;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public MoisturePackage getMoisturePackage() {
		return (MoisturePackage)getEPackage();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @deprecated
	 * @generated
	 */
	@Deprecated
	public static MoisturePackage getPackage() {
		return MoisturePackage.eINSTANCE;
	}

} //MoistureFactoryImpl
