/**
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *      Data In Motion - initial API and implementation
 */
package org.gecko.mac.moisture.impl;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;

import org.eclipse.emf.ecore.impl.EPackageImpl;

import org.gecko.mac.lorawan.LoRaWANPackage;

import org.gecko.mac.moisture.CalibrationData;
import org.gecko.mac.moisture.M5MoistureUplink;
import org.gecko.mac.moisture.MoistureFactory;
import org.gecko.mac.moisture.MoisturePackage;
import org.gecko.mac.moisture.MoistureReading;
import org.gecko.mac.moisture.MoistureSensorData;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model <b>Package</b>.
 * <!-- end-user-doc -->
 * @generated
 */
public class MoisturePackageImpl extends EPackageImpl implements MoisturePackage {
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass m5MoistureUplinkEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass moistureSensorDataEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass moistureReadingEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass calibrationDataEClass = null;

	/**
	 * Creates an instance of the model <b>Package</b>, registered with
	 * {@link org.eclipse.emf.ecore.EPackage.Registry EPackage.Registry} by the package
	 * package URI value.
	 * <p>Note: the correct way to create the package is via the static
	 * factory method {@link #init init()}, which also performs
	 * initialization of the package, or returns the registered package,
	 * if one already exists.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.emf.ecore.EPackage.Registry
	 * @see org.gecko.mac.moisture.MoisturePackage#eNS_URI
	 * @see #init()
	 * @generated
	 */
	private MoisturePackageImpl() {
		super(eNS_URI, MoistureFactory.eINSTANCE);
	}
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private static boolean isInited = false;

	/**
	 * Creates, registers, and initializes the <b>Package</b> for this model, and for any others upon which it depends.
	 *
	 * <p>This method is used to initialize {@link MoisturePackage#eINSTANCE} when that field is accessed.
	 * Clients should not invoke it directly. Instead, they should simply access that field to obtain the package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #eNS_URI
	 * @see #createPackageContents()
	 * @see #initializePackageContents()
	 * @generated
	 */
	public static MoisturePackage init() {
		if (isInited) return (MoisturePackage)EPackage.Registry.INSTANCE.getEPackage(MoisturePackage.eNS_URI);

		// Obtain or create and register package
		Object registeredMoisturePackage = EPackage.Registry.INSTANCE.get(eNS_URI);
		MoisturePackageImpl theMoisturePackage = registeredMoisturePackage instanceof MoisturePackageImpl ? (MoisturePackageImpl)registeredMoisturePackage : new MoisturePackageImpl();

		isInited = true;

		// Initialize simple dependencies
		LoRaWANPackage.eINSTANCE.eClass();

		// Create package meta-data objects
		theMoisturePackage.createPackageContents();

		// Initialize created meta-data
		theMoisturePackage.initializePackageContents();

		// Mark meta-data to indicate it can't be changed
		theMoisturePackage.freeze();

		// Update the registry and return the package
		EPackage.Registry.INSTANCE.put(MoisturePackage.eNS_URI, theMoisturePackage);
		return theMoisturePackage;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getM5MoistureUplink() {
		return m5MoistureUplinkEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getM5MoistureUplink_Object() {
		return (EReference)m5MoistureUplinkEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getMoistureSensorData() {
		return moistureSensorDataEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getMoistureSensorData_Moisture() {
		return (EReference)moistureSensorDataEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getMoistureSensorData_Cal() {
		return (EReference)moistureSensorDataEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getMoistureSensorData_Timestamp() {
		return (EAttribute)moistureSensorDataEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getMoistureReading() {
		return moistureReadingEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getMoistureReading_Percent() {
		return (EAttribute)moistureReadingEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getMoistureReading_Raw() {
		return (EAttribute)moistureReadingEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getCalibrationData() {
		return calibrationDataEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getCalibrationData_Dry() {
		return (EAttribute)calibrationDataEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getCalibrationData_Wet() {
		return (EAttribute)calibrationDataEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public MoistureFactory getMoistureFactory() {
		return (MoistureFactory)getEFactoryInstance();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private boolean isCreated = false;

	/**
	 * Creates the meta-model objects for the package.  This method is
	 * guarded to have no affect on any invocation but its first.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void createPackageContents() {
		if (isCreated) return;
		isCreated = true;

		// Create classes and their features
		m5MoistureUplinkEClass = createEClass(M5_MOISTURE_UPLINK);
		createEReference(m5MoistureUplinkEClass, M5_MOISTURE_UPLINK__OBJECT);

		moistureSensorDataEClass = createEClass(MOISTURE_SENSOR_DATA);
		createEReference(moistureSensorDataEClass, MOISTURE_SENSOR_DATA__MOISTURE);
		createEReference(moistureSensorDataEClass, MOISTURE_SENSOR_DATA__CAL);
		createEAttribute(moistureSensorDataEClass, MOISTURE_SENSOR_DATA__TIMESTAMP);

		moistureReadingEClass = createEClass(MOISTURE_READING);
		createEAttribute(moistureReadingEClass, MOISTURE_READING__PERCENT);
		createEAttribute(moistureReadingEClass, MOISTURE_READING__RAW);

		calibrationDataEClass = createEClass(CALIBRATION_DATA);
		createEAttribute(calibrationDataEClass, CALIBRATION_DATA__DRY);
		createEAttribute(calibrationDataEClass, CALIBRATION_DATA__WET);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private boolean isInitialized = false;

	/**
	 * Complete the initialization of the package and its meta-model.  This
	 * method is guarded to have no affect on any invocation but its first.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void initializePackageContents() {
		if (isInitialized) return;
		isInitialized = true;

		// Initialize package
		setName(eNAME);
		setNsPrefix(eNS_PREFIX);
		setNsURI(eNS_URI);

		// Obtain other dependent packages
		LoRaWANPackage theLoRaWANPackage = (LoRaWANPackage)EPackage.Registry.INSTANCE.getEPackage(LoRaWANPackage.eNS_URI);

		// Create type parameters

		// Set bounds for type parameters

		// Add supertypes to classes
		m5MoistureUplinkEClass.getESuperTypes().add(theLoRaWANPackage.getUplinkMessage());

		// Initialize classes, features, and operations; add parameters
		initEClass(m5MoistureUplinkEClass, M5MoistureUplink.class, "M5MoistureUplink", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getM5MoistureUplink_Object(), this.getMoistureSensorData(), null, "object", null, 1, 1, M5MoistureUplink.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(moistureSensorDataEClass, MoistureSensorData.class, "MoistureSensorData", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getMoistureSensorData_Moisture(), this.getMoistureReading(), null, "moisture", null, 1, 1, MoistureSensorData.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getMoistureSensorData_Cal(), this.getCalibrationData(), null, "cal", null, 1, 1, MoistureSensorData.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getMoistureSensorData_Timestamp(), ecorePackage.getEDouble(), "timestamp", null, 0, 1, MoistureSensorData.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(moistureReadingEClass, MoistureReading.class, "MoistureReading", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getMoistureReading_Percent(), ecorePackage.getEInt(), "percent", null, 0, 1, MoistureReading.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getMoistureReading_Raw(), ecorePackage.getEInt(), "raw", null, 0, 1, MoistureReading.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(calibrationDataEClass, CalibrationData.class, "CalibrationData", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getCalibrationData_Dry(), ecorePackage.getEInt(), "dry", null, 0, 1, CalibrationData.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getCalibrationData_Wet(), ecorePackage.getEInt(), "wet", null, 0, 1, CalibrationData.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		// Create resource
		createResource(eNS_URI);

		// Create annotations
		// Version
		createVersionAnnotations();
		// http://www.eclipse.org/emf/2002/GenModel
		createGenModelAnnotations();
		// codec.type
		createCodecAnnotations();
	}

	/**
	 * Initializes the annotations for <b>Version</b>.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void createVersionAnnotations() {
		String source = "Version";
		addAnnotation
		  (this,
		   source,
		   new String[] {
			   "value", "1.0"
		   });
	}

	/**
	 * Initializes the annotations for <b>http://www.eclipse.org/emf/2002/GenModel</b>.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void createGenModelAnnotations() {
		String source = "http://www.eclipse.org/emf/2002/GenModel";
		addAnnotation
		  (this,
		   source,
		   new String[] {
			   "modelName", "Moisture",
			   "complianceLevel", "21.0",
			   "copyrightText", "Copyright (c) 2012 - 2025 Data In Motion and others.\nAll rights reserved.\n\nThis program and the accompanying materials are made\navailable under the terms of the Eclipse Public License 2.0\nwhich is available at https://www.eclipse.org/legal/epl-2.0/\n\nSPDX-License-Identifier: EPL-2.0\n\nContributors:\n     Data In Motion - initial API and implementation",
			   "resource", "XMI",
			   "oSGiCompatible", "true",
			   "prefix", "Moisture",
			   "basePackage", "org.gecko.mac"
		   });
		addAnnotation
		  (getM5MoistureUplink_Object(),
		   source,
		   new String[] {
			   "documentation", "Decoded sensor payload containing moisture readings and calibration data"
		   });
		addAnnotation
		  (moistureSensorDataEClass,
		   source,
		   new String[] {
			   "documentation", "Container for moisture sensor data including readings, calibration, and timestamp"
		   });
		addAnnotation
		  (getMoistureSensorData_Moisture(),
		   source,
		   new String[] {
			   "documentation", "Current moisture measurement with percentage and raw ADC value"
		   });
		addAnnotation
		  (getMoistureSensorData_Cal(),
		   source,
		   new String[] {
			   "documentation", "Calibration values for dry and wet soil conditions"
		   });
		addAnnotation
		  (getMoistureSensorData_Timestamp(),
		   source,
		   new String[] {
			   "documentation", "Sensor timestamp in seconds since device boot"
		   });
		addAnnotation
		  (moistureReadingEClass,
		   source,
		   new String[] {
			   "documentation", "Moisture measurement data with calibrated percentage and raw ADC value"
		   });
		addAnnotation
		  (getMoistureReading_Percent(),
		   source,
		   new String[] {
			   "documentation", "Calibrated moisture percentage (0-100%)"
		   });
		addAnnotation
		  (getMoistureReading_Raw(),
		   source,
		   new String[] {
			   "documentation", "Raw ADC reading from moisture sensor"
		   });
		addAnnotation
		  (calibrationDataEClass,
		   source,
		   new String[] {
			   "documentation", "Calibration reference values for converting raw ADC readings to percentage"
		   });
		addAnnotation
		  (getCalibrationData_Dry(),
		   source,
		   new String[] {
			   "documentation", "Raw ADC value for completely dry soil (0% moisture)"
		   });
		addAnnotation
		  (getCalibrationData_Wet(),
		   source,
		   new String[] {
			   "documentation", "Raw ADC value for completely wet soil (100% moisture)"
		   });
	}

	/**
	 * Initializes the annotations for <b>codec.type</b>.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void createCodecAnnotations() {
		String source = "codec.type";
		addAnnotation
		  (m5MoistureUplinkEClass,
		   source,
		   new String[] {
			   "value", "M5 Moisture v1"
		   });
	}

} //MoisturePackageImpl
