/*
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *      Data In Motion - initial API and implementation
 */
package org.gecko.mac.moisture.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.MinimalEObjectImpl;

import org.gecko.mac.moisture.CalibrationData;
import org.gecko.mac.moisture.MoisturePackage;
import org.gecko.mac.moisture.MoistureReading;
import org.gecko.mac.moisture.MoistureSensorData;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Sensor Data</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link org.gecko.mac.moisture.impl.MoistureSensorDataImpl#getMoisture <em>Moisture</em>}</li>
 *   <li>{@link org.gecko.mac.moisture.impl.MoistureSensorDataImpl#getCal <em>Cal</em>}</li>
 *   <li>{@link org.gecko.mac.moisture.impl.MoistureSensorDataImpl#getTimestamp <em>Timestamp</em>}</li>
 * </ul>
 *
 * @generated
 */
public class MoistureSensorDataImpl extends MinimalEObjectImpl.Container implements MoistureSensorData {
	/**
	 * The cached value of the '{@link #getMoisture() <em>Moisture</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getMoisture()
	 * @generated
	 * @ordered
	 */
	protected MoistureReading moisture;

	/**
	 * The cached value of the '{@link #getCal() <em>Cal</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCal()
	 * @generated
	 * @ordered
	 */
	protected CalibrationData cal;

	/**
	 * The default value of the '{@link #getTimestamp() <em>Timestamp</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTimestamp()
	 * @generated
	 * @ordered
	 */
	protected static final double TIMESTAMP_EDEFAULT = 0.0;

	/**
	 * The cached value of the '{@link #getTimestamp() <em>Timestamp</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTimestamp()
	 * @generated
	 * @ordered
	 */
	protected double timestamp = TIMESTAMP_EDEFAULT;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected MoistureSensorDataImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return MoisturePackage.Literals.MOISTURE_SENSOR_DATA;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public MoistureReading getMoisture() {
		return moisture;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetMoisture(MoistureReading newMoisture, NotificationChain msgs) {
		MoistureReading oldMoisture = moisture;
		moisture = newMoisture;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, MoisturePackage.MOISTURE_SENSOR_DATA__MOISTURE, oldMoisture, newMoisture);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setMoisture(MoistureReading newMoisture) {
		if (newMoisture != moisture) {
			NotificationChain msgs = null;
			if (moisture != null)
				msgs = ((InternalEObject)moisture).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - MoisturePackage.MOISTURE_SENSOR_DATA__MOISTURE, null, msgs);
			if (newMoisture != null)
				msgs = ((InternalEObject)newMoisture).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - MoisturePackage.MOISTURE_SENSOR_DATA__MOISTURE, null, msgs);
			msgs = basicSetMoisture(newMoisture, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, MoisturePackage.MOISTURE_SENSOR_DATA__MOISTURE, newMoisture, newMoisture));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public CalibrationData getCal() {
		return cal;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetCal(CalibrationData newCal, NotificationChain msgs) {
		CalibrationData oldCal = cal;
		cal = newCal;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, MoisturePackage.MOISTURE_SENSOR_DATA__CAL, oldCal, newCal);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setCal(CalibrationData newCal) {
		if (newCal != cal) {
			NotificationChain msgs = null;
			if (cal != null)
				msgs = ((InternalEObject)cal).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - MoisturePackage.MOISTURE_SENSOR_DATA__CAL, null, msgs);
			if (newCal != null)
				msgs = ((InternalEObject)newCal).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - MoisturePackage.MOISTURE_SENSOR_DATA__CAL, null, msgs);
			msgs = basicSetCal(newCal, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, MoisturePackage.MOISTURE_SENSOR_DATA__CAL, newCal, newCal));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public double getTimestamp() {
		return timestamp;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setTimestamp(double newTimestamp) {
		double oldTimestamp = timestamp;
		timestamp = newTimestamp;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, MoisturePackage.MOISTURE_SENSOR_DATA__TIMESTAMP, oldTimestamp, timestamp));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case MoisturePackage.MOISTURE_SENSOR_DATA__MOISTURE:
				return basicSetMoisture(null, msgs);
			case MoisturePackage.MOISTURE_SENSOR_DATA__CAL:
				return basicSetCal(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case MoisturePackage.MOISTURE_SENSOR_DATA__MOISTURE:
				return getMoisture();
			case MoisturePackage.MOISTURE_SENSOR_DATA__CAL:
				return getCal();
			case MoisturePackage.MOISTURE_SENSOR_DATA__TIMESTAMP:
				return getTimestamp();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case MoisturePackage.MOISTURE_SENSOR_DATA__MOISTURE:
				setMoisture((MoistureReading)newValue);
				return;
			case MoisturePackage.MOISTURE_SENSOR_DATA__CAL:
				setCal((CalibrationData)newValue);
				return;
			case MoisturePackage.MOISTURE_SENSOR_DATA__TIMESTAMP:
				setTimestamp((Double)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case MoisturePackage.MOISTURE_SENSOR_DATA__MOISTURE:
				setMoisture((MoistureReading)null);
				return;
			case MoisturePackage.MOISTURE_SENSOR_DATA__CAL:
				setCal((CalibrationData)null);
				return;
			case MoisturePackage.MOISTURE_SENSOR_DATA__TIMESTAMP:
				setTimestamp(TIMESTAMP_EDEFAULT);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case MoisturePackage.MOISTURE_SENSOR_DATA__MOISTURE:
				return moisture != null;
			case MoisturePackage.MOISTURE_SENSOR_DATA__CAL:
				return cal != null;
			case MoisturePackage.MOISTURE_SENSOR_DATA__TIMESTAMP:
				return timestamp != TIMESTAMP_EDEFAULT;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuilder result = new StringBuilder(super.toString());
		result.append(" (timestamp: ");
		result.append(timestamp);
		result.append(')');
		return result.toString();
	}

} //MoistureSensorDataImpl
