/*
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *      Ilenia Salvadori - initial API and implementation
 */
package org.gecko.mac.moisturesensor;

import org.gecko.mac.lorawan.UplinkMessage;

import org.osgi.annotation.versioning.ProviderType;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Atom Lite</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link org.gecko.mac.moisturesensor.AtomLite#getObject <em>Object</em>}</li>
 * </ul>
 *
 * @see org.gecko.mac.moisturesensor.MoistureSensorPackage#getAtomLite()
 * @model annotation="codec.type M5AtomLite='AtomLite'"
 * @generated
 */
@ProviderType
public interface AtomLite extends UplinkMessage {
	/**
	 * Returns the value of the '<em><b>Object</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Object</em>' containment reference.
	 * @see #setObject(AtomLiteObject)
	 * @see org.gecko.mac.moisturesensor.MoistureSensorPackage#getAtomLite_Object()
	 * @model containment="true"
	 * @generated
	 */
	AtomLiteObject getObject();

	/**
	 * Sets the value of the '{@link org.gecko.mac.moisturesensor.AtomLite#getObject <em>Object</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Object</em>' containment reference.
	 * @see #getObject()
	 * @generated
	 */
	void setObject(AtomLiteObject value);

} // AtomLite
