/*
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *      Ilenia Salvadori - initial API and implementation
 */
package org.gecko.mac.moisturesensor;

import org.eclipse.emf.ecore.EObject;

import org.osgi.annotation.versioning.ProviderType;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Atom Lite Object</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link org.gecko.mac.moisturesensor.AtomLiteObject#getTimestamp <em>Timestamp</em>}</li>
 *   <li>{@link org.gecko.mac.moisturesensor.AtomLiteObject#getMoistureRaw <em>Moisture Raw</em>}</li>
 *   <li>{@link org.gecko.mac.moisturesensor.AtomLiteObject#getMoisturePercent <em>Moisture Percent</em>}</li>
 *   <li>{@link org.gecko.mac.moisturesensor.AtomLiteObject#getCalDry <em>Cal Dry</em>}</li>
 *   <li>{@link org.gecko.mac.moisturesensor.AtomLiteObject#getCalWet <em>Cal Wet</em>}</li>
 * </ul>
 *
 * @see org.gecko.mac.moisturesensor.MoistureSensorPackage#getAtomLiteObject()
 * @model
 * @generated
 */
@ProviderType
public interface AtomLiteObject extends EObject {
	/**
	 * Returns the value of the '<em><b>Timestamp</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Timestamp</em>' attribute.
	 * @see #setTimestamp(String)
	 * @see org.gecko.mac.moisturesensor.MoistureSensorPackage#getAtomLiteObject_Timestamp()
	 * @model
	 * @generated
	 */
	String getTimestamp();

	/**
	 * Sets the value of the '{@link org.gecko.mac.moisturesensor.AtomLiteObject#getTimestamp <em>Timestamp</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Timestamp</em>' attribute.
	 * @see #getTimestamp()
	 * @generated
	 */
	void setTimestamp(String value);

	/**
	 * Returns the value of the '<em><b>Moisture Raw</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Moisture Raw</em>' attribute.
	 * @see #setMoistureRaw(float)
	 * @see org.gecko.mac.moisturesensor.MoistureSensorPackage#getAtomLiteObject_MoistureRaw()
	 * @model extendedMetaData="name='moisture_raw'"
	 * @generated
	 */
	float getMoistureRaw();

	/**
	 * Sets the value of the '{@link org.gecko.mac.moisturesensor.AtomLiteObject#getMoistureRaw <em>Moisture Raw</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Moisture Raw</em>' attribute.
	 * @see #getMoistureRaw()
	 * @generated
	 */
	void setMoistureRaw(float value);

	/**
	 * Returns the value of the '<em><b>Moisture Percent</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Moisture Percent</em>' attribute.
	 * @see #setMoisturePercent(float)
	 * @see org.gecko.mac.moisturesensor.MoistureSensorPackage#getAtomLiteObject_MoisturePercent()
	 * @model extendedMetaData="name='moisture_percent'"
	 * @generated
	 */
	float getMoisturePercent();

	/**
	 * Sets the value of the '{@link org.gecko.mac.moisturesensor.AtomLiteObject#getMoisturePercent <em>Moisture Percent</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Moisture Percent</em>' attribute.
	 * @see #getMoisturePercent()
	 * @generated
	 */
	void setMoisturePercent(float value);

	/**
	 * Returns the value of the '<em><b>Cal Dry</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Cal Dry</em>' attribute.
	 * @see #setCalDry(float)
	 * @see org.gecko.mac.moisturesensor.MoistureSensorPackage#getAtomLiteObject_CalDry()
	 * @model extendedMetaData="name='cal_dry'"
	 * @generated
	 */
	float getCalDry();

	/**
	 * Sets the value of the '{@link org.gecko.mac.moisturesensor.AtomLiteObject#getCalDry <em>Cal Dry</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Cal Dry</em>' attribute.
	 * @see #getCalDry()
	 * @generated
	 */
	void setCalDry(float value);

	/**
	 * Returns the value of the '<em><b>Cal Wet</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Cal Wet</em>' attribute.
	 * @see #setCalWet(float)
	 * @see org.gecko.mac.moisturesensor.MoistureSensorPackage#getAtomLiteObject_CalWet()
	 * @model extendedMetaData="name='cal_wet'"
	 * @generated
	 */
	float getCalWet();

	/**
	 * Sets the value of the '{@link org.gecko.mac.moisturesensor.AtomLiteObject#getCalWet <em>Cal Wet</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Cal Wet</em>' attribute.
	 * @see #getCalWet()
	 * @generated
	 */
	void setCalWet(float value);

} // AtomLiteObject
