/*
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *      Ilenia Salvadori - initial API and implementation
 */
package org.gecko.mac.moisturesensor;

import org.eclipse.emf.ecore.EObject;

import org.osgi.annotation.versioning.ProviderType;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>M5 Moisture Sensor Data</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * Container for moisture sensor data including readings, calibration, and timestamp
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link org.gecko.mac.moisturesensor.M5MoistureSensorData#getMoisture <em>Moisture</em>}</li>
 *   <li>{@link org.gecko.mac.moisturesensor.M5MoistureSensorData#getCal <em>Cal</em>}</li>
 *   <li>{@link org.gecko.mac.moisturesensor.M5MoistureSensorData#getTimestamp <em>Timestamp</em>}</li>
 * </ul>
 *
 * @see org.gecko.mac.moisturesensor.MoistureSensorPackage#getM5MoistureSensorData()
 * @model
 * @generated
 */
@ProviderType
public interface M5MoistureSensorData extends EObject {
	/**
	 * Returns the value of the '<em><b>Moisture</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Current moisture measurement with percentage and raw ADC value
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Moisture</em>' containment reference.
	 * @see #setMoisture(M5MoistureReading)
	 * @see org.gecko.mac.moisturesensor.MoistureSensorPackage#getM5MoistureSensorData_Moisture()
	 * @model containment="true" required="true"
	 * @generated
	 */
	M5MoistureReading getMoisture();

	/**
	 * Sets the value of the '{@link org.gecko.mac.moisturesensor.M5MoistureSensorData#getMoisture <em>Moisture</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Moisture</em>' containment reference.
	 * @see #getMoisture()
	 * @generated
	 */
	void setMoisture(M5MoistureReading value);

	/**
	 * Returns the value of the '<em><b>Cal</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Calibration values for dry and wet soil conditions
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Cal</em>' containment reference.
	 * @see #setCal(M5CalibrationData)
	 * @see org.gecko.mac.moisturesensor.MoistureSensorPackage#getM5MoistureSensorData_Cal()
	 * @model containment="true" required="true"
	 * @generated
	 */
	M5CalibrationData getCal();

	/**
	 * Sets the value of the '{@link org.gecko.mac.moisturesensor.M5MoistureSensorData#getCal <em>Cal</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Cal</em>' containment reference.
	 * @see #getCal()
	 * @generated
	 */
	void setCal(M5CalibrationData value);

	/**
	 * Returns the value of the '<em><b>Timestamp</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Sensor timestamp in seconds since device boot
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Timestamp</em>' attribute.
	 * @see #setTimestamp(double)
	 * @see org.gecko.mac.moisturesensor.MoistureSensorPackage#getM5MoistureSensorData_Timestamp()
	 * @model
	 * @generated
	 */
	double getTimestamp();

	/**
	 * Sets the value of the '{@link org.gecko.mac.moisturesensor.M5MoistureSensorData#getTimestamp <em>Timestamp</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Timestamp</em>' attribute.
	 * @see #getTimestamp()
	 * @generated
	 */
	void setTimestamp(double value);

} // M5MoistureSensorData
