/*
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *      Ilenia Salvadori - initial API and implementation
 */
package org.gecko.mac.moisturesensor;

import org.eclipse.emf.ecore.EFactory;

import org.osgi.annotation.versioning.ProviderType;

/**
 * <!-- begin-user-doc -->
 * The <b>Factory</b> for the model.
 * It provides a create method for each non-abstract class of the model.
 * <!-- end-user-doc -->
 * @see org.gecko.mac.moisturesensor.MoistureSensorPackage
 * @generated
 */
@ProviderType
public interface MoistureSensorFactory extends EFactory {
	/**
	 * The singleton instance of the factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	MoistureSensorFactory eINSTANCE = org.gecko.mac.moisturesensor.impl.MoistureSensorFactoryImpl.init();

	/**
	 * Returns a new object of class '<em>Atom Lite</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Atom Lite</em>'.
	 * @generated
	 */
	AtomLite createAtomLite();

	/**
	 * Returns a new object of class '<em>Atom Lite Object</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Atom Lite Object</em>'.
	 * @generated
	 */
	AtomLiteObject createAtomLiteObject();

	/**
	 * Returns a new object of class '<em>M5 Moisture Uplink</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>M5 Moisture Uplink</em>'.
	 * @generated
	 */
	M5MoistureUplink createM5MoistureUplink();

	/**
	 * Returns a new object of class '<em>M5 Moisture Sensor Data</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>M5 Moisture Sensor Data</em>'.
	 * @generated
	 */
	M5MoistureSensorData createM5MoistureSensorData();

	/**
	 * Returns a new object of class '<em>M5 Moisture Reading</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>M5 Moisture Reading</em>'.
	 * @generated
	 */
	M5MoistureReading createM5MoistureReading();

	/**
	 * Returns a new object of class '<em>M5 Calibration Data</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>M5 Calibration Data</em>'.
	 * @generated
	 */
	M5CalibrationData createM5CalibrationData();

	/**
	 * Returns a new object of class '<em>Atom Lite V2</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Atom Lite V2</em>'.
	 * @generated
	 */
	AtomLiteV2 createAtomLiteV2();

	/**
	 * Returns a new object of class '<em>M5 Moisture Uplink V2</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>M5 Moisture Uplink V2</em>'.
	 * @generated
	 */
	M5MoistureUplinkV2 createM5MoistureUplinkV2();

	/**
	 * Returns the package supported by this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the package supported by this factory.
	 * @generated
	 */
	MoistureSensorPackage getMoistureSensorPackage();

} //MoistureSensorFactory
