/*
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *      Ilenia Salvadori - initial API and implementation
 */
package org.gecko.mac.moisturesensor;


import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EReference;

import org.gecko.emf.osgi.annotation.provide.EPackage;

import org.gecko.mac.lorawan.LoRaWANPackage;

import org.osgi.annotation.versioning.ProviderType;

/**
 * <!-- begin-user-doc -->
 * The <b>Package</b> for the model.
 * It contains accessors for the meta objects to represent
 * <ul>
 *   <li>each class,</li>
 *   <li>each feature of each class,</li>
 *   <li>each operation of each class,</li>
 *   <li>each enum,</li>
 *   <li>and each data type</li>
 * </ul>
 * <!-- end-user-doc -->
 * @see org.gecko.mac.moisturesensor.MoistureSensorFactory
 * @model kind="package"
 *        annotation="Version value='1.0'"
 *        annotation="http://www.eclipse.org/emf/2002/GenModel modelName='MoistureSensor' copyrightText='Copyright (c) 2012 - 2025 Data In Motion and others.\nAll rights reserved.\n\nThis program and the accompanying materials are made\navailable under the terms of the Eclipse Public License 2.0\nwhich is available at https://www.eclipse.org/legal/epl-2.0/\n\nSPDX-License-Identifier: EPL-2.0\n\nContributors:\n     Ilenia Salvadori - initial API and implementation' resource='XMI' oSGiCompatible='true' basePackage='org.gecko.mac'"
 * @generated
 */
@ProviderType
@EPackage(uri = MoistureSensorPackage.eNS_URI, genModel = "/model/moisture-sensor.genmodel", genModelSourceLocations = {"model/moisture-sensor.genmodel","org.gecko.mac.moisture.sensor.model/model/moisture-sensor.genmodel"}, ecore="/model/moisture-sensor.ecore", ecoreSourceLocations="/model/moisture-sensor.ecore")
public interface MoistureSensorPackage extends org.eclipse.emf.ecore.EPackage {
	/**
	 * The package name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNAME = "moisturesensor";

	/**
	 * The package namespace URI.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_URI = "http://datainmotion.com/mac/sensor/moisture/1.0.0";

	/**
	 * The package namespace name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_PREFIX = "moisture-sensor";

	/**
	 * The singleton instance of the package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	MoistureSensorPackage eINSTANCE = org.gecko.mac.moisturesensor.impl.MoistureSensorPackageImpl.init();

	/**
	 * The meta object id for the '{@link org.gecko.mac.moisturesensor.impl.AtomLiteImpl <em>Atom Lite</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.gecko.mac.moisturesensor.impl.AtomLiteImpl
	 * @see org.gecko.mac.moisturesensor.impl.MoistureSensorPackageImpl#getAtomLite()
	 * @generated
	 */
	int ATOM_LITE = 0;

	/**
	 * The feature id for the '<em><b>Deduplication Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATOM_LITE__DEDUPLICATION_ID = LoRaWANPackage.UPLINK_MESSAGE__DEDUPLICATION_ID;

	/**
	 * The feature id for the '<em><b>Time</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATOM_LITE__TIME = LoRaWANPackage.UPLINK_MESSAGE__TIME;

	/**
	 * The feature id for the '<em><b>Adr</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATOM_LITE__ADR = LoRaWANPackage.UPLINK_MESSAGE__ADR;

	/**
	 * The feature id for the '<em><b>Dr</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATOM_LITE__DR = LoRaWANPackage.UPLINK_MESSAGE__DR;

	/**
	 * The feature id for the '<em><b>FCnt</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATOM_LITE__FCNT = LoRaWANPackage.UPLINK_MESSAGE__FCNT;

	/**
	 * The feature id for the '<em><b>FPort</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATOM_LITE__FPORT = LoRaWANPackage.UPLINK_MESSAGE__FPORT;

	/**
	 * The feature id for the '<em><b>Confirmed</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATOM_LITE__CONFIRMED = LoRaWANPackage.UPLINK_MESSAGE__CONFIRMED;

	/**
	 * The feature id for the '<em><b>Data</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATOM_LITE__DATA = LoRaWANPackage.UPLINK_MESSAGE__DATA;

	/**
	 * The feature id for the '<em><b>Device Info</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATOM_LITE__DEVICE_INFO = LoRaWANPackage.UPLINK_MESSAGE__DEVICE_INFO;

	/**
	 * The feature id for the '<em><b>Rx Info</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATOM_LITE__RX_INFO = LoRaWANPackage.UPLINK_MESSAGE__RX_INFO;

	/**
	 * The feature id for the '<em><b>Dev Addr</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATOM_LITE__DEV_ADDR = LoRaWANPackage.UPLINK_MESSAGE__DEV_ADDR;

	/**
	 * The feature id for the '<em><b>Tx Info</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATOM_LITE__TX_INFO = LoRaWANPackage.UPLINK_MESSAGE__TX_INFO;

	/**
	 * The feature id for the '<em><b>Object</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATOM_LITE__OBJECT = LoRaWANPackage.UPLINK_MESSAGE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Atom Lite</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATOM_LITE_FEATURE_COUNT = LoRaWANPackage.UPLINK_MESSAGE_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Atom Lite</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATOM_LITE_OPERATION_COUNT = LoRaWANPackage.UPLINK_MESSAGE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.gecko.mac.moisturesensor.impl.AtomLiteObjectImpl <em>Atom Lite Object</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.gecko.mac.moisturesensor.impl.AtomLiteObjectImpl
	 * @see org.gecko.mac.moisturesensor.impl.MoistureSensorPackageImpl#getAtomLiteObject()
	 * @generated
	 */
	int ATOM_LITE_OBJECT = 1;

	/**
	 * The feature id for the '<em><b>Timestamp</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATOM_LITE_OBJECT__TIMESTAMP = 0;

	/**
	 * The feature id for the '<em><b>Moisture Raw</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATOM_LITE_OBJECT__MOISTURE_RAW = 1;

	/**
	 * The feature id for the '<em><b>Moisture Percent</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATOM_LITE_OBJECT__MOISTURE_PERCENT = 2;

	/**
	 * The feature id for the '<em><b>Cal Dry</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATOM_LITE_OBJECT__CAL_DRY = 3;

	/**
	 * The feature id for the '<em><b>Cal Wet</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATOM_LITE_OBJECT__CAL_WET = 4;

	/**
	 * The number of structural features of the '<em>Atom Lite Object</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATOM_LITE_OBJECT_FEATURE_COUNT = 5;

	/**
	 * The number of operations of the '<em>Atom Lite Object</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATOM_LITE_OBJECT_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.gecko.mac.moisturesensor.impl.M5MoistureUplinkImpl <em>M5 Moisture Uplink</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.gecko.mac.moisturesensor.impl.M5MoistureUplinkImpl
	 * @see org.gecko.mac.moisturesensor.impl.MoistureSensorPackageImpl#getM5MoistureUplink()
	 * @generated
	 */
	int M5_MOISTURE_UPLINK = 2;

	/**
	 * The feature id for the '<em><b>Deduplication Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int M5_MOISTURE_UPLINK__DEDUPLICATION_ID = LoRaWANPackage.UPLINK_MESSAGE__DEDUPLICATION_ID;

	/**
	 * The feature id for the '<em><b>Time</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int M5_MOISTURE_UPLINK__TIME = LoRaWANPackage.UPLINK_MESSAGE__TIME;

	/**
	 * The feature id for the '<em><b>Adr</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int M5_MOISTURE_UPLINK__ADR = LoRaWANPackage.UPLINK_MESSAGE__ADR;

	/**
	 * The feature id for the '<em><b>Dr</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int M5_MOISTURE_UPLINK__DR = LoRaWANPackage.UPLINK_MESSAGE__DR;

	/**
	 * The feature id for the '<em><b>FCnt</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int M5_MOISTURE_UPLINK__FCNT = LoRaWANPackage.UPLINK_MESSAGE__FCNT;

	/**
	 * The feature id for the '<em><b>FPort</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int M5_MOISTURE_UPLINK__FPORT = LoRaWANPackage.UPLINK_MESSAGE__FPORT;

	/**
	 * The feature id for the '<em><b>Confirmed</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int M5_MOISTURE_UPLINK__CONFIRMED = LoRaWANPackage.UPLINK_MESSAGE__CONFIRMED;

	/**
	 * The feature id for the '<em><b>Data</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int M5_MOISTURE_UPLINK__DATA = LoRaWANPackage.UPLINK_MESSAGE__DATA;

	/**
	 * The feature id for the '<em><b>Device Info</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int M5_MOISTURE_UPLINK__DEVICE_INFO = LoRaWANPackage.UPLINK_MESSAGE__DEVICE_INFO;

	/**
	 * The feature id for the '<em><b>Rx Info</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int M5_MOISTURE_UPLINK__RX_INFO = LoRaWANPackage.UPLINK_MESSAGE__RX_INFO;

	/**
	 * The feature id for the '<em><b>Dev Addr</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int M5_MOISTURE_UPLINK__DEV_ADDR = LoRaWANPackage.UPLINK_MESSAGE__DEV_ADDR;

	/**
	 * The feature id for the '<em><b>Tx Info</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int M5_MOISTURE_UPLINK__TX_INFO = LoRaWANPackage.UPLINK_MESSAGE__TX_INFO;

	/**
	 * The feature id for the '<em><b>Object</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int M5_MOISTURE_UPLINK__OBJECT = LoRaWANPackage.UPLINK_MESSAGE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>M5 Moisture Uplink</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int M5_MOISTURE_UPLINK_FEATURE_COUNT = LoRaWANPackage.UPLINK_MESSAGE_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>M5 Moisture Uplink</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int M5_MOISTURE_UPLINK_OPERATION_COUNT = LoRaWANPackage.UPLINK_MESSAGE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.gecko.mac.moisturesensor.impl.M5MoistureSensorDataImpl <em>M5 Moisture Sensor Data</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.gecko.mac.moisturesensor.impl.M5MoistureSensorDataImpl
	 * @see org.gecko.mac.moisturesensor.impl.MoistureSensorPackageImpl#getM5MoistureSensorData()
	 * @generated
	 */
	int M5_MOISTURE_SENSOR_DATA = 3;

	/**
	 * The feature id for the '<em><b>Moisture</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int M5_MOISTURE_SENSOR_DATA__MOISTURE = 0;

	/**
	 * The feature id for the '<em><b>Cal</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int M5_MOISTURE_SENSOR_DATA__CAL = 1;

	/**
	 * The feature id for the '<em><b>Timestamp</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int M5_MOISTURE_SENSOR_DATA__TIMESTAMP = 2;

	/**
	 * The number of structural features of the '<em>M5 Moisture Sensor Data</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int M5_MOISTURE_SENSOR_DATA_FEATURE_COUNT = 3;

	/**
	 * The number of operations of the '<em>M5 Moisture Sensor Data</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int M5_MOISTURE_SENSOR_DATA_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.gecko.mac.moisturesensor.impl.M5MoistureReadingImpl <em>M5 Moisture Reading</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.gecko.mac.moisturesensor.impl.M5MoistureReadingImpl
	 * @see org.gecko.mac.moisturesensor.impl.MoistureSensorPackageImpl#getM5MoistureReading()
	 * @generated
	 */
	int M5_MOISTURE_READING = 4;

	/**
	 * The feature id for the '<em><b>Percent</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int M5_MOISTURE_READING__PERCENT = 0;

	/**
	 * The feature id for the '<em><b>Raw</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int M5_MOISTURE_READING__RAW = 1;

	/**
	 * The number of structural features of the '<em>M5 Moisture Reading</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int M5_MOISTURE_READING_FEATURE_COUNT = 2;

	/**
	 * The number of operations of the '<em>M5 Moisture Reading</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int M5_MOISTURE_READING_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.gecko.mac.moisturesensor.impl.M5CalibrationDataImpl <em>M5 Calibration Data</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.gecko.mac.moisturesensor.impl.M5CalibrationDataImpl
	 * @see org.gecko.mac.moisturesensor.impl.MoistureSensorPackageImpl#getM5CalibrationData()
	 * @generated
	 */
	int M5_CALIBRATION_DATA = 5;

	/**
	 * The feature id for the '<em><b>Dry</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int M5_CALIBRATION_DATA__DRY = 0;

	/**
	 * The feature id for the '<em><b>Wet</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int M5_CALIBRATION_DATA__WET = 1;

	/**
	 * The number of structural features of the '<em>M5 Calibration Data</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int M5_CALIBRATION_DATA_FEATURE_COUNT = 2;

	/**
	 * The number of operations of the '<em>M5 Calibration Data</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int M5_CALIBRATION_DATA_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.gecko.mac.moisturesensor.impl.AtomLiteV2Impl <em>Atom Lite V2</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.gecko.mac.moisturesensor.impl.AtomLiteV2Impl
	 * @see org.gecko.mac.moisturesensor.impl.MoistureSensorPackageImpl#getAtomLiteV2()
	 * @generated
	 */
	int ATOM_LITE_V2 = 6;

	/**
	 * The feature id for the '<em><b>Deduplication Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATOM_LITE_V2__DEDUPLICATION_ID = LoRaWANPackage.UPLINK_MESSAGE__DEDUPLICATION_ID;

	/**
	 * The feature id for the '<em><b>Time</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATOM_LITE_V2__TIME = LoRaWANPackage.UPLINK_MESSAGE__TIME;

	/**
	 * The feature id for the '<em><b>Adr</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATOM_LITE_V2__ADR = LoRaWANPackage.UPLINK_MESSAGE__ADR;

	/**
	 * The feature id for the '<em><b>Dr</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATOM_LITE_V2__DR = LoRaWANPackage.UPLINK_MESSAGE__DR;

	/**
	 * The feature id for the '<em><b>FCnt</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATOM_LITE_V2__FCNT = LoRaWANPackage.UPLINK_MESSAGE__FCNT;

	/**
	 * The feature id for the '<em><b>FPort</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATOM_LITE_V2__FPORT = LoRaWANPackage.UPLINK_MESSAGE__FPORT;

	/**
	 * The feature id for the '<em><b>Confirmed</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATOM_LITE_V2__CONFIRMED = LoRaWANPackage.UPLINK_MESSAGE__CONFIRMED;

	/**
	 * The feature id for the '<em><b>Data</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATOM_LITE_V2__DATA = LoRaWANPackage.UPLINK_MESSAGE__DATA;

	/**
	 * The feature id for the '<em><b>Device Info</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATOM_LITE_V2__DEVICE_INFO = LoRaWANPackage.UPLINK_MESSAGE__DEVICE_INFO;

	/**
	 * The feature id for the '<em><b>Rx Info</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATOM_LITE_V2__RX_INFO = LoRaWANPackage.UPLINK_MESSAGE__RX_INFO;

	/**
	 * The feature id for the '<em><b>Dev Addr</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATOM_LITE_V2__DEV_ADDR = LoRaWANPackage.UPLINK_MESSAGE__DEV_ADDR;

	/**
	 * The feature id for the '<em><b>Tx Info</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATOM_LITE_V2__TX_INFO = LoRaWANPackage.UPLINK_MESSAGE__TX_INFO;

	/**
	 * The feature id for the '<em><b>Object</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATOM_LITE_V2__OBJECT = LoRaWANPackage.UPLINK_MESSAGE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Atom Lite V2</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATOM_LITE_V2_FEATURE_COUNT = LoRaWANPackage.UPLINK_MESSAGE_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Atom Lite V2</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATOM_LITE_V2_OPERATION_COUNT = LoRaWANPackage.UPLINK_MESSAGE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.gecko.mac.moisturesensor.impl.M5MoistureUplinkV2Impl <em>M5 Moisture Uplink V2</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.gecko.mac.moisturesensor.impl.M5MoistureUplinkV2Impl
	 * @see org.gecko.mac.moisturesensor.impl.MoistureSensorPackageImpl#getM5MoistureUplinkV2()
	 * @generated
	 */
	int M5_MOISTURE_UPLINK_V2 = 7;

	/**
	 * The feature id for the '<em><b>Deduplication Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int M5_MOISTURE_UPLINK_V2__DEDUPLICATION_ID = LoRaWANPackage.UPLINK_MESSAGE__DEDUPLICATION_ID;

	/**
	 * The feature id for the '<em><b>Time</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int M5_MOISTURE_UPLINK_V2__TIME = LoRaWANPackage.UPLINK_MESSAGE__TIME;

	/**
	 * The feature id for the '<em><b>Adr</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int M5_MOISTURE_UPLINK_V2__ADR = LoRaWANPackage.UPLINK_MESSAGE__ADR;

	/**
	 * The feature id for the '<em><b>Dr</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int M5_MOISTURE_UPLINK_V2__DR = LoRaWANPackage.UPLINK_MESSAGE__DR;

	/**
	 * The feature id for the '<em><b>FCnt</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int M5_MOISTURE_UPLINK_V2__FCNT = LoRaWANPackage.UPLINK_MESSAGE__FCNT;

	/**
	 * The feature id for the '<em><b>FPort</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int M5_MOISTURE_UPLINK_V2__FPORT = LoRaWANPackage.UPLINK_MESSAGE__FPORT;

	/**
	 * The feature id for the '<em><b>Confirmed</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int M5_MOISTURE_UPLINK_V2__CONFIRMED = LoRaWANPackage.UPLINK_MESSAGE__CONFIRMED;

	/**
	 * The feature id for the '<em><b>Data</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int M5_MOISTURE_UPLINK_V2__DATA = LoRaWANPackage.UPLINK_MESSAGE__DATA;

	/**
	 * The feature id for the '<em><b>Device Info</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int M5_MOISTURE_UPLINK_V2__DEVICE_INFO = LoRaWANPackage.UPLINK_MESSAGE__DEVICE_INFO;

	/**
	 * The feature id for the '<em><b>Rx Info</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int M5_MOISTURE_UPLINK_V2__RX_INFO = LoRaWANPackage.UPLINK_MESSAGE__RX_INFO;

	/**
	 * The feature id for the '<em><b>Dev Addr</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int M5_MOISTURE_UPLINK_V2__DEV_ADDR = LoRaWANPackage.UPLINK_MESSAGE__DEV_ADDR;

	/**
	 * The feature id for the '<em><b>Tx Info</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int M5_MOISTURE_UPLINK_V2__TX_INFO = LoRaWANPackage.UPLINK_MESSAGE__TX_INFO;

	/**
	 * The feature id for the '<em><b>Object</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int M5_MOISTURE_UPLINK_V2__OBJECT = LoRaWANPackage.UPLINK_MESSAGE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>M5 Moisture Uplink V2</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int M5_MOISTURE_UPLINK_V2_FEATURE_COUNT = LoRaWANPackage.UPLINK_MESSAGE_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>M5 Moisture Uplink V2</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int M5_MOISTURE_UPLINK_V2_OPERATION_COUNT = LoRaWANPackage.UPLINK_MESSAGE_OPERATION_COUNT + 0;


	/**
	 * Returns the meta object for class '{@link org.gecko.mac.moisturesensor.AtomLite <em>Atom Lite</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Atom Lite</em>'.
	 * @see org.gecko.mac.moisturesensor.AtomLite
	 * @generated
	 */
	EClass getAtomLite();

	/**
	 * Returns the meta object for the containment reference '{@link org.gecko.mac.moisturesensor.AtomLite#getObject <em>Object</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Object</em>'.
	 * @see org.gecko.mac.moisturesensor.AtomLite#getObject()
	 * @see #getAtomLite()
	 * @generated
	 */
	EReference getAtomLite_Object();

	/**
	 * Returns the meta object for class '{@link org.gecko.mac.moisturesensor.AtomLiteObject <em>Atom Lite Object</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Atom Lite Object</em>'.
	 * @see org.gecko.mac.moisturesensor.AtomLiteObject
	 * @generated
	 */
	EClass getAtomLiteObject();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.mac.moisturesensor.AtomLiteObject#getTimestamp <em>Timestamp</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Timestamp</em>'.
	 * @see org.gecko.mac.moisturesensor.AtomLiteObject#getTimestamp()
	 * @see #getAtomLiteObject()
	 * @generated
	 */
	EAttribute getAtomLiteObject_Timestamp();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.mac.moisturesensor.AtomLiteObject#getMoistureRaw <em>Moisture Raw</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Moisture Raw</em>'.
	 * @see org.gecko.mac.moisturesensor.AtomLiteObject#getMoistureRaw()
	 * @see #getAtomLiteObject()
	 * @generated
	 */
	EAttribute getAtomLiteObject_MoistureRaw();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.mac.moisturesensor.AtomLiteObject#getMoisturePercent <em>Moisture Percent</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Moisture Percent</em>'.
	 * @see org.gecko.mac.moisturesensor.AtomLiteObject#getMoisturePercent()
	 * @see #getAtomLiteObject()
	 * @generated
	 */
	EAttribute getAtomLiteObject_MoisturePercent();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.mac.moisturesensor.AtomLiteObject#getCalDry <em>Cal Dry</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Cal Dry</em>'.
	 * @see org.gecko.mac.moisturesensor.AtomLiteObject#getCalDry()
	 * @see #getAtomLiteObject()
	 * @generated
	 */
	EAttribute getAtomLiteObject_CalDry();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.mac.moisturesensor.AtomLiteObject#getCalWet <em>Cal Wet</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Cal Wet</em>'.
	 * @see org.gecko.mac.moisturesensor.AtomLiteObject#getCalWet()
	 * @see #getAtomLiteObject()
	 * @generated
	 */
	EAttribute getAtomLiteObject_CalWet();

	/**
	 * Returns the meta object for class '{@link org.gecko.mac.moisturesensor.M5MoistureUplink <em>M5 Moisture Uplink</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>M5 Moisture Uplink</em>'.
	 * @see org.gecko.mac.moisturesensor.M5MoistureUplink
	 * @generated
	 */
	EClass getM5MoistureUplink();

	/**
	 * Returns the meta object for the containment reference '{@link org.gecko.mac.moisturesensor.M5MoistureUplink#getObject <em>Object</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Object</em>'.
	 * @see org.gecko.mac.moisturesensor.M5MoistureUplink#getObject()
	 * @see #getM5MoistureUplink()
	 * @generated
	 */
	EReference getM5MoistureUplink_Object();

	/**
	 * Returns the meta object for class '{@link org.gecko.mac.moisturesensor.M5MoistureSensorData <em>M5 Moisture Sensor Data</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>M5 Moisture Sensor Data</em>'.
	 * @see org.gecko.mac.moisturesensor.M5MoistureSensorData
	 * @generated
	 */
	EClass getM5MoistureSensorData();

	/**
	 * Returns the meta object for the containment reference '{@link org.gecko.mac.moisturesensor.M5MoistureSensorData#getMoisture <em>Moisture</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Moisture</em>'.
	 * @see org.gecko.mac.moisturesensor.M5MoistureSensorData#getMoisture()
	 * @see #getM5MoistureSensorData()
	 * @generated
	 */
	EReference getM5MoistureSensorData_Moisture();

	/**
	 * Returns the meta object for the containment reference '{@link org.gecko.mac.moisturesensor.M5MoistureSensorData#getCal <em>Cal</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Cal</em>'.
	 * @see org.gecko.mac.moisturesensor.M5MoistureSensorData#getCal()
	 * @see #getM5MoistureSensorData()
	 * @generated
	 */
	EReference getM5MoistureSensorData_Cal();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.mac.moisturesensor.M5MoistureSensorData#getTimestamp <em>Timestamp</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Timestamp</em>'.
	 * @see org.gecko.mac.moisturesensor.M5MoistureSensorData#getTimestamp()
	 * @see #getM5MoistureSensorData()
	 * @generated
	 */
	EAttribute getM5MoistureSensorData_Timestamp();

	/**
	 * Returns the meta object for class '{@link org.gecko.mac.moisturesensor.M5MoistureReading <em>M5 Moisture Reading</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>M5 Moisture Reading</em>'.
	 * @see org.gecko.mac.moisturesensor.M5MoistureReading
	 * @generated
	 */
	EClass getM5MoistureReading();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.mac.moisturesensor.M5MoistureReading#getPercent <em>Percent</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Percent</em>'.
	 * @see org.gecko.mac.moisturesensor.M5MoistureReading#getPercent()
	 * @see #getM5MoistureReading()
	 * @generated
	 */
	EAttribute getM5MoistureReading_Percent();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.mac.moisturesensor.M5MoistureReading#getRaw <em>Raw</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Raw</em>'.
	 * @see org.gecko.mac.moisturesensor.M5MoistureReading#getRaw()
	 * @see #getM5MoistureReading()
	 * @generated
	 */
	EAttribute getM5MoistureReading_Raw();

	/**
	 * Returns the meta object for class '{@link org.gecko.mac.moisturesensor.M5CalibrationData <em>M5 Calibration Data</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>M5 Calibration Data</em>'.
	 * @see org.gecko.mac.moisturesensor.M5CalibrationData
	 * @generated
	 */
	EClass getM5CalibrationData();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.mac.moisturesensor.M5CalibrationData#getDry <em>Dry</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Dry</em>'.
	 * @see org.gecko.mac.moisturesensor.M5CalibrationData#getDry()
	 * @see #getM5CalibrationData()
	 * @generated
	 */
	EAttribute getM5CalibrationData_Dry();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.mac.moisturesensor.M5CalibrationData#getWet <em>Wet</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Wet</em>'.
	 * @see org.gecko.mac.moisturesensor.M5CalibrationData#getWet()
	 * @see #getM5CalibrationData()
	 * @generated
	 */
	EAttribute getM5CalibrationData_Wet();

	/**
	 * Returns the meta object for class '{@link org.gecko.mac.moisturesensor.AtomLiteV2 <em>Atom Lite V2</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Atom Lite V2</em>'.
	 * @see org.gecko.mac.moisturesensor.AtomLiteV2
	 * @generated
	 */
	EClass getAtomLiteV2();

	/**
	 * Returns the meta object for the containment reference '{@link org.gecko.mac.moisturesensor.AtomLiteV2#getObject <em>Object</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Object</em>'.
	 * @see org.gecko.mac.moisturesensor.AtomLiteV2#getObject()
	 * @see #getAtomLiteV2()
	 * @generated
	 */
	EReference getAtomLiteV2_Object();

	/**
	 * Returns the meta object for class '{@link org.gecko.mac.moisturesensor.M5MoistureUplinkV2 <em>M5 Moisture Uplink V2</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>M5 Moisture Uplink V2</em>'.
	 * @see org.gecko.mac.moisturesensor.M5MoistureUplinkV2
	 * @generated
	 */
	EClass getM5MoistureUplinkV2();

	/**
	 * Returns the meta object for the containment reference '{@link org.gecko.mac.moisturesensor.M5MoistureUplinkV2#getObject <em>Object</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Object</em>'.
	 * @see org.gecko.mac.moisturesensor.M5MoistureUplinkV2#getObject()
	 * @see #getM5MoistureUplinkV2()
	 * @generated
	 */
	EReference getM5MoistureUplinkV2_Object();

	/**
	 * Returns the factory that creates the instances of the model.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the factory that creates the instances of the model.
	 * @generated
	 */
	MoistureSensorFactory getMoistureSensorFactory();

	/**
	 * <!-- begin-user-doc -->
	 * Defines literals for the meta objects that represent
	 * <ul>
	 *   <li>each class,</li>
	 *   <li>each feature of each class,</li>
	 *   <li>each operation of each class,</li>
	 *   <li>each enum,</li>
	 *   <li>and each data type</li>
	 * </ul>
	 * <!-- end-user-doc -->
	 * @generated
	 */
	interface Literals {
		/**
		 * The meta object literal for the '{@link org.gecko.mac.moisturesensor.impl.AtomLiteImpl <em>Atom Lite</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.gecko.mac.moisturesensor.impl.AtomLiteImpl
		 * @see org.gecko.mac.moisturesensor.impl.MoistureSensorPackageImpl#getAtomLite()
		 * @generated
		 */
		EClass ATOM_LITE = eINSTANCE.getAtomLite();

		/**
		 * The meta object literal for the '<em><b>Object</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ATOM_LITE__OBJECT = eINSTANCE.getAtomLite_Object();

		/**
		 * The meta object literal for the '{@link org.gecko.mac.moisturesensor.impl.AtomLiteObjectImpl <em>Atom Lite Object</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.gecko.mac.moisturesensor.impl.AtomLiteObjectImpl
		 * @see org.gecko.mac.moisturesensor.impl.MoistureSensorPackageImpl#getAtomLiteObject()
		 * @generated
		 */
		EClass ATOM_LITE_OBJECT = eINSTANCE.getAtomLiteObject();

		/**
		 * The meta object literal for the '<em><b>Timestamp</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ATOM_LITE_OBJECT__TIMESTAMP = eINSTANCE.getAtomLiteObject_Timestamp();

		/**
		 * The meta object literal for the '<em><b>Moisture Raw</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ATOM_LITE_OBJECT__MOISTURE_RAW = eINSTANCE.getAtomLiteObject_MoistureRaw();

		/**
		 * The meta object literal for the '<em><b>Moisture Percent</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ATOM_LITE_OBJECT__MOISTURE_PERCENT = eINSTANCE.getAtomLiteObject_MoisturePercent();

		/**
		 * The meta object literal for the '<em><b>Cal Dry</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ATOM_LITE_OBJECT__CAL_DRY = eINSTANCE.getAtomLiteObject_CalDry();

		/**
		 * The meta object literal for the '<em><b>Cal Wet</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ATOM_LITE_OBJECT__CAL_WET = eINSTANCE.getAtomLiteObject_CalWet();

		/**
		 * The meta object literal for the '{@link org.gecko.mac.moisturesensor.impl.M5MoistureUplinkImpl <em>M5 Moisture Uplink</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.gecko.mac.moisturesensor.impl.M5MoistureUplinkImpl
		 * @see org.gecko.mac.moisturesensor.impl.MoistureSensorPackageImpl#getM5MoistureUplink()
		 * @generated
		 */
		EClass M5_MOISTURE_UPLINK = eINSTANCE.getM5MoistureUplink();

		/**
		 * The meta object literal for the '<em><b>Object</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference M5_MOISTURE_UPLINK__OBJECT = eINSTANCE.getM5MoistureUplink_Object();

		/**
		 * The meta object literal for the '{@link org.gecko.mac.moisturesensor.impl.M5MoistureSensorDataImpl <em>M5 Moisture Sensor Data</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.gecko.mac.moisturesensor.impl.M5MoistureSensorDataImpl
		 * @see org.gecko.mac.moisturesensor.impl.MoistureSensorPackageImpl#getM5MoistureSensorData()
		 * @generated
		 */
		EClass M5_MOISTURE_SENSOR_DATA = eINSTANCE.getM5MoistureSensorData();

		/**
		 * The meta object literal for the '<em><b>Moisture</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference M5_MOISTURE_SENSOR_DATA__MOISTURE = eINSTANCE.getM5MoistureSensorData_Moisture();

		/**
		 * The meta object literal for the '<em><b>Cal</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference M5_MOISTURE_SENSOR_DATA__CAL = eINSTANCE.getM5MoistureSensorData_Cal();

		/**
		 * The meta object literal for the '<em><b>Timestamp</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute M5_MOISTURE_SENSOR_DATA__TIMESTAMP = eINSTANCE.getM5MoistureSensorData_Timestamp();

		/**
		 * The meta object literal for the '{@link org.gecko.mac.moisturesensor.impl.M5MoistureReadingImpl <em>M5 Moisture Reading</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.gecko.mac.moisturesensor.impl.M5MoistureReadingImpl
		 * @see org.gecko.mac.moisturesensor.impl.MoistureSensorPackageImpl#getM5MoistureReading()
		 * @generated
		 */
		EClass M5_MOISTURE_READING = eINSTANCE.getM5MoistureReading();

		/**
		 * The meta object literal for the '<em><b>Percent</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute M5_MOISTURE_READING__PERCENT = eINSTANCE.getM5MoistureReading_Percent();

		/**
		 * The meta object literal for the '<em><b>Raw</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute M5_MOISTURE_READING__RAW = eINSTANCE.getM5MoistureReading_Raw();

		/**
		 * The meta object literal for the '{@link org.gecko.mac.moisturesensor.impl.M5CalibrationDataImpl <em>M5 Calibration Data</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.gecko.mac.moisturesensor.impl.M5CalibrationDataImpl
		 * @see org.gecko.mac.moisturesensor.impl.MoistureSensorPackageImpl#getM5CalibrationData()
		 * @generated
		 */
		EClass M5_CALIBRATION_DATA = eINSTANCE.getM5CalibrationData();

		/**
		 * The meta object literal for the '<em><b>Dry</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute M5_CALIBRATION_DATA__DRY = eINSTANCE.getM5CalibrationData_Dry();

		/**
		 * The meta object literal for the '<em><b>Wet</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute M5_CALIBRATION_DATA__WET = eINSTANCE.getM5CalibrationData_Wet();

		/**
		 * The meta object literal for the '{@link org.gecko.mac.moisturesensor.impl.AtomLiteV2Impl <em>Atom Lite V2</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.gecko.mac.moisturesensor.impl.AtomLiteV2Impl
		 * @see org.gecko.mac.moisturesensor.impl.MoistureSensorPackageImpl#getAtomLiteV2()
		 * @generated
		 */
		EClass ATOM_LITE_V2 = eINSTANCE.getAtomLiteV2();

		/**
		 * The meta object literal for the '<em><b>Object</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ATOM_LITE_V2__OBJECT = eINSTANCE.getAtomLiteV2_Object();

		/**
		 * The meta object literal for the '{@link org.gecko.mac.moisturesensor.impl.M5MoistureUplinkV2Impl <em>M5 Moisture Uplink V2</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.gecko.mac.moisturesensor.impl.M5MoistureUplinkV2Impl
		 * @see org.gecko.mac.moisturesensor.impl.MoistureSensorPackageImpl#getM5MoistureUplinkV2()
		 * @generated
		 */
		EClass M5_MOISTURE_UPLINK_V2 = eINSTANCE.getM5MoistureUplinkV2();

		/**
		 * The meta object literal for the '<em><b>Object</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference M5_MOISTURE_UPLINK_V2__OBJECT = eINSTANCE.getM5MoistureUplinkV2_Object();

	}

} //MoistureSensorPackage
