/*
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *      Ilenia Salvadori - initial API and implementation
 */
package org.gecko.mac.moisturesensor.impl;

import org.eclipse.emf.common.notify.Notification;

import org.eclipse.emf.ecore.EClass;

import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.MinimalEObjectImpl;

import org.gecko.mac.moisturesensor.AtomLiteObject;
import org.gecko.mac.moisturesensor.MoistureSensorPackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Atom Lite Object</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link org.gecko.mac.moisturesensor.impl.AtomLiteObjectImpl#getTimestamp <em>Timestamp</em>}</li>
 *   <li>{@link org.gecko.mac.moisturesensor.impl.AtomLiteObjectImpl#getMoistureRaw <em>Moisture Raw</em>}</li>
 *   <li>{@link org.gecko.mac.moisturesensor.impl.AtomLiteObjectImpl#getMoisturePercent <em>Moisture Percent</em>}</li>
 *   <li>{@link org.gecko.mac.moisturesensor.impl.AtomLiteObjectImpl#getCalDry <em>Cal Dry</em>}</li>
 *   <li>{@link org.gecko.mac.moisturesensor.impl.AtomLiteObjectImpl#getCalWet <em>Cal Wet</em>}</li>
 * </ul>
 *
 * @generated
 */
public class AtomLiteObjectImpl extends MinimalEObjectImpl.Container implements AtomLiteObject {
	/**
	 * The default value of the '{@link #getTimestamp() <em>Timestamp</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTimestamp()
	 * @generated
	 * @ordered
	 */
	protected static final String TIMESTAMP_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getTimestamp() <em>Timestamp</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTimestamp()
	 * @generated
	 * @ordered
	 */
	protected String timestamp = TIMESTAMP_EDEFAULT;

	/**
	 * The default value of the '{@link #getMoistureRaw() <em>Moisture Raw</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getMoistureRaw()
	 * @generated
	 * @ordered
	 */
	protected static final float MOISTURE_RAW_EDEFAULT = 0.0F;

	/**
	 * The cached value of the '{@link #getMoistureRaw() <em>Moisture Raw</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getMoistureRaw()
	 * @generated
	 * @ordered
	 */
	protected float moistureRaw = MOISTURE_RAW_EDEFAULT;

	/**
	 * The default value of the '{@link #getMoisturePercent() <em>Moisture Percent</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getMoisturePercent()
	 * @generated
	 * @ordered
	 */
	protected static final float MOISTURE_PERCENT_EDEFAULT = 0.0F;

	/**
	 * The cached value of the '{@link #getMoisturePercent() <em>Moisture Percent</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getMoisturePercent()
	 * @generated
	 * @ordered
	 */
	protected float moisturePercent = MOISTURE_PERCENT_EDEFAULT;

	/**
	 * The default value of the '{@link #getCalDry() <em>Cal Dry</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCalDry()
	 * @generated
	 * @ordered
	 */
	protected static final float CAL_DRY_EDEFAULT = 0.0F;

	/**
	 * The cached value of the '{@link #getCalDry() <em>Cal Dry</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCalDry()
	 * @generated
	 * @ordered
	 */
	protected float calDry = CAL_DRY_EDEFAULT;

	/**
	 * The default value of the '{@link #getCalWet() <em>Cal Wet</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCalWet()
	 * @generated
	 * @ordered
	 */
	protected static final float CAL_WET_EDEFAULT = 0.0F;

	/**
	 * The cached value of the '{@link #getCalWet() <em>Cal Wet</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCalWet()
	 * @generated
	 * @ordered
	 */
	protected float calWet = CAL_WET_EDEFAULT;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected AtomLiteObjectImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return MoistureSensorPackage.Literals.ATOM_LITE_OBJECT;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getTimestamp() {
		return timestamp;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setTimestamp(String newTimestamp) {
		String oldTimestamp = timestamp;
		timestamp = newTimestamp;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, MoistureSensorPackage.ATOM_LITE_OBJECT__TIMESTAMP, oldTimestamp, timestamp));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public float getMoistureRaw() {
		return moistureRaw;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setMoistureRaw(float newMoistureRaw) {
		float oldMoistureRaw = moistureRaw;
		moistureRaw = newMoistureRaw;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, MoistureSensorPackage.ATOM_LITE_OBJECT__MOISTURE_RAW, oldMoistureRaw, moistureRaw));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public float getMoisturePercent() {
		return moisturePercent;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setMoisturePercent(float newMoisturePercent) {
		float oldMoisturePercent = moisturePercent;
		moisturePercent = newMoisturePercent;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, MoistureSensorPackage.ATOM_LITE_OBJECT__MOISTURE_PERCENT, oldMoisturePercent, moisturePercent));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public float getCalDry() {
		return calDry;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setCalDry(float newCalDry) {
		float oldCalDry = calDry;
		calDry = newCalDry;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, MoistureSensorPackage.ATOM_LITE_OBJECT__CAL_DRY, oldCalDry, calDry));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public float getCalWet() {
		return calWet;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setCalWet(float newCalWet) {
		float oldCalWet = calWet;
		calWet = newCalWet;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, MoistureSensorPackage.ATOM_LITE_OBJECT__CAL_WET, oldCalWet, calWet));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case MoistureSensorPackage.ATOM_LITE_OBJECT__TIMESTAMP:
				return getTimestamp();
			case MoistureSensorPackage.ATOM_LITE_OBJECT__MOISTURE_RAW:
				return getMoistureRaw();
			case MoistureSensorPackage.ATOM_LITE_OBJECT__MOISTURE_PERCENT:
				return getMoisturePercent();
			case MoistureSensorPackage.ATOM_LITE_OBJECT__CAL_DRY:
				return getCalDry();
			case MoistureSensorPackage.ATOM_LITE_OBJECT__CAL_WET:
				return getCalWet();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case MoistureSensorPackage.ATOM_LITE_OBJECT__TIMESTAMP:
				setTimestamp((String)newValue);
				return;
			case MoistureSensorPackage.ATOM_LITE_OBJECT__MOISTURE_RAW:
				setMoistureRaw((Float)newValue);
				return;
			case MoistureSensorPackage.ATOM_LITE_OBJECT__MOISTURE_PERCENT:
				setMoisturePercent((Float)newValue);
				return;
			case MoistureSensorPackage.ATOM_LITE_OBJECT__CAL_DRY:
				setCalDry((Float)newValue);
				return;
			case MoistureSensorPackage.ATOM_LITE_OBJECT__CAL_WET:
				setCalWet((Float)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case MoistureSensorPackage.ATOM_LITE_OBJECT__TIMESTAMP:
				setTimestamp(TIMESTAMP_EDEFAULT);
				return;
			case MoistureSensorPackage.ATOM_LITE_OBJECT__MOISTURE_RAW:
				setMoistureRaw(MOISTURE_RAW_EDEFAULT);
				return;
			case MoistureSensorPackage.ATOM_LITE_OBJECT__MOISTURE_PERCENT:
				setMoisturePercent(MOISTURE_PERCENT_EDEFAULT);
				return;
			case MoistureSensorPackage.ATOM_LITE_OBJECT__CAL_DRY:
				setCalDry(CAL_DRY_EDEFAULT);
				return;
			case MoistureSensorPackage.ATOM_LITE_OBJECT__CAL_WET:
				setCalWet(CAL_WET_EDEFAULT);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case MoistureSensorPackage.ATOM_LITE_OBJECT__TIMESTAMP:
				return TIMESTAMP_EDEFAULT == null ? timestamp != null : !TIMESTAMP_EDEFAULT.equals(timestamp);
			case MoistureSensorPackage.ATOM_LITE_OBJECT__MOISTURE_RAW:
				return moistureRaw != MOISTURE_RAW_EDEFAULT;
			case MoistureSensorPackage.ATOM_LITE_OBJECT__MOISTURE_PERCENT:
				return moisturePercent != MOISTURE_PERCENT_EDEFAULT;
			case MoistureSensorPackage.ATOM_LITE_OBJECT__CAL_DRY:
				return calDry != CAL_DRY_EDEFAULT;
			case MoistureSensorPackage.ATOM_LITE_OBJECT__CAL_WET:
				return calWet != CAL_WET_EDEFAULT;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuilder result = new StringBuilder(super.toString());
		result.append(" (timestamp: ");
		result.append(timestamp);
		result.append(", moistureRaw: ");
		result.append(moistureRaw);
		result.append(", moisturePercent: ");
		result.append(moisturePercent);
		result.append(", calDry: ");
		result.append(calDry);
		result.append(", calWet: ");
		result.append(calWet);
		result.append(')');
		return result.toString();
	}

} //AtomLiteObjectImpl
