/*
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *      Ilenia Salvadori - initial API and implementation
 */
package org.gecko.mac.moisturesensor.impl;

import org.eclipse.emf.common.notify.Notification;

import org.eclipse.emf.ecore.EClass;

import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.MinimalEObjectImpl;

import org.gecko.mac.moisturesensor.M5CalibrationData;
import org.gecko.mac.moisturesensor.MoistureSensorPackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>M5 Calibration Data</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link org.gecko.mac.moisturesensor.impl.M5CalibrationDataImpl#getDry <em>Dry</em>}</li>
 *   <li>{@link org.gecko.mac.moisturesensor.impl.M5CalibrationDataImpl#getWet <em>Wet</em>}</li>
 * </ul>
 *
 * @generated
 */
public class M5CalibrationDataImpl extends MinimalEObjectImpl.Container implements M5CalibrationData {
	/**
	 * The default value of the '{@link #getDry() <em>Dry</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDry()
	 * @generated
	 * @ordered
	 */
	protected static final int DRY_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getDry() <em>Dry</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDry()
	 * @generated
	 * @ordered
	 */
	protected int dry = DRY_EDEFAULT;

	/**
	 * The default value of the '{@link #getWet() <em>Wet</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getWet()
	 * @generated
	 * @ordered
	 */
	protected static final int WET_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getWet() <em>Wet</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getWet()
	 * @generated
	 * @ordered
	 */
	protected int wet = WET_EDEFAULT;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected M5CalibrationDataImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return MoistureSensorPackage.Literals.M5_CALIBRATION_DATA;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int getDry() {
		return dry;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setDry(int newDry) {
		int oldDry = dry;
		dry = newDry;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, MoistureSensorPackage.M5_CALIBRATION_DATA__DRY, oldDry, dry));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int getWet() {
		return wet;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setWet(int newWet) {
		int oldWet = wet;
		wet = newWet;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, MoistureSensorPackage.M5_CALIBRATION_DATA__WET, oldWet, wet));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case MoistureSensorPackage.M5_CALIBRATION_DATA__DRY:
				return getDry();
			case MoistureSensorPackage.M5_CALIBRATION_DATA__WET:
				return getWet();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case MoistureSensorPackage.M5_CALIBRATION_DATA__DRY:
				setDry((Integer)newValue);
				return;
			case MoistureSensorPackage.M5_CALIBRATION_DATA__WET:
				setWet((Integer)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case MoistureSensorPackage.M5_CALIBRATION_DATA__DRY:
				setDry(DRY_EDEFAULT);
				return;
			case MoistureSensorPackage.M5_CALIBRATION_DATA__WET:
				setWet(WET_EDEFAULT);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case MoistureSensorPackage.M5_CALIBRATION_DATA__DRY:
				return dry != DRY_EDEFAULT;
			case MoistureSensorPackage.M5_CALIBRATION_DATA__WET:
				return wet != WET_EDEFAULT;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuilder result = new StringBuilder(super.toString());
		result.append(" (dry: ");
		result.append(dry);
		result.append(", wet: ");
		result.append(wet);
		result.append(')');
		return result.toString();
	}

} //M5CalibrationDataImpl
