/*
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *      Ilenia Salvadori - initial API and implementation
 */
package org.gecko.mac.moisturesensor.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.MinimalEObjectImpl;

import org.gecko.mac.moisturesensor.M5CalibrationData;
import org.gecko.mac.moisturesensor.M5MoistureReading;
import org.gecko.mac.moisturesensor.M5MoistureSensorData;
import org.gecko.mac.moisturesensor.MoistureSensorPackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>M5 Moisture Sensor Data</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link org.gecko.mac.moisturesensor.impl.M5MoistureSensorDataImpl#getMoisture <em>Moisture</em>}</li>
 *   <li>{@link org.gecko.mac.moisturesensor.impl.M5MoistureSensorDataImpl#getCal <em>Cal</em>}</li>
 *   <li>{@link org.gecko.mac.moisturesensor.impl.M5MoistureSensorDataImpl#getTimestamp <em>Timestamp</em>}</li>
 * </ul>
 *
 * @generated
 */
public class M5MoistureSensorDataImpl extends MinimalEObjectImpl.Container implements M5MoistureSensorData {
	/**
	 * The cached value of the '{@link #getMoisture() <em>Moisture</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getMoisture()
	 * @generated
	 * @ordered
	 */
	protected M5MoistureReading moisture;

	/**
	 * The cached value of the '{@link #getCal() <em>Cal</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCal()
	 * @generated
	 * @ordered
	 */
	protected M5CalibrationData cal;

	/**
	 * The default value of the '{@link #getTimestamp() <em>Timestamp</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTimestamp()
	 * @generated
	 * @ordered
	 */
	protected static final double TIMESTAMP_EDEFAULT = 0.0;

	/**
	 * The cached value of the '{@link #getTimestamp() <em>Timestamp</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTimestamp()
	 * @generated
	 * @ordered
	 */
	protected double timestamp = TIMESTAMP_EDEFAULT;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected M5MoistureSensorDataImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return MoistureSensorPackage.Literals.M5_MOISTURE_SENSOR_DATA;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public M5MoistureReading getMoisture() {
		return moisture;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetMoisture(M5MoistureReading newMoisture, NotificationChain msgs) {
		M5MoistureReading oldMoisture = moisture;
		moisture = newMoisture;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, MoistureSensorPackage.M5_MOISTURE_SENSOR_DATA__MOISTURE, oldMoisture, newMoisture);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setMoisture(M5MoistureReading newMoisture) {
		if (newMoisture != moisture) {
			NotificationChain msgs = null;
			if (moisture != null)
				msgs = ((InternalEObject)moisture).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - MoistureSensorPackage.M5_MOISTURE_SENSOR_DATA__MOISTURE, null, msgs);
			if (newMoisture != null)
				msgs = ((InternalEObject)newMoisture).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - MoistureSensorPackage.M5_MOISTURE_SENSOR_DATA__MOISTURE, null, msgs);
			msgs = basicSetMoisture(newMoisture, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, MoistureSensorPackage.M5_MOISTURE_SENSOR_DATA__MOISTURE, newMoisture, newMoisture));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public M5CalibrationData getCal() {
		return cal;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetCal(M5CalibrationData newCal, NotificationChain msgs) {
		M5CalibrationData oldCal = cal;
		cal = newCal;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, MoistureSensorPackage.M5_MOISTURE_SENSOR_DATA__CAL, oldCal, newCal);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setCal(M5CalibrationData newCal) {
		if (newCal != cal) {
			NotificationChain msgs = null;
			if (cal != null)
				msgs = ((InternalEObject)cal).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - MoistureSensorPackage.M5_MOISTURE_SENSOR_DATA__CAL, null, msgs);
			if (newCal != null)
				msgs = ((InternalEObject)newCal).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - MoistureSensorPackage.M5_MOISTURE_SENSOR_DATA__CAL, null, msgs);
			msgs = basicSetCal(newCal, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, MoistureSensorPackage.M5_MOISTURE_SENSOR_DATA__CAL, newCal, newCal));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public double getTimestamp() {
		return timestamp;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setTimestamp(double newTimestamp) {
		double oldTimestamp = timestamp;
		timestamp = newTimestamp;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, MoistureSensorPackage.M5_MOISTURE_SENSOR_DATA__TIMESTAMP, oldTimestamp, timestamp));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case MoistureSensorPackage.M5_MOISTURE_SENSOR_DATA__MOISTURE:
				return basicSetMoisture(null, msgs);
			case MoistureSensorPackage.M5_MOISTURE_SENSOR_DATA__CAL:
				return basicSetCal(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case MoistureSensorPackage.M5_MOISTURE_SENSOR_DATA__MOISTURE:
				return getMoisture();
			case MoistureSensorPackage.M5_MOISTURE_SENSOR_DATA__CAL:
				return getCal();
			case MoistureSensorPackage.M5_MOISTURE_SENSOR_DATA__TIMESTAMP:
				return getTimestamp();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case MoistureSensorPackage.M5_MOISTURE_SENSOR_DATA__MOISTURE:
				setMoisture((M5MoistureReading)newValue);
				return;
			case MoistureSensorPackage.M5_MOISTURE_SENSOR_DATA__CAL:
				setCal((M5CalibrationData)newValue);
				return;
			case MoistureSensorPackage.M5_MOISTURE_SENSOR_DATA__TIMESTAMP:
				setTimestamp((Double)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case MoistureSensorPackage.M5_MOISTURE_SENSOR_DATA__MOISTURE:
				setMoisture((M5MoistureReading)null);
				return;
			case MoistureSensorPackage.M5_MOISTURE_SENSOR_DATA__CAL:
				setCal((M5CalibrationData)null);
				return;
			case MoistureSensorPackage.M5_MOISTURE_SENSOR_DATA__TIMESTAMP:
				setTimestamp(TIMESTAMP_EDEFAULT);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case MoistureSensorPackage.M5_MOISTURE_SENSOR_DATA__MOISTURE:
				return moisture != null;
			case MoistureSensorPackage.M5_MOISTURE_SENSOR_DATA__CAL:
				return cal != null;
			case MoistureSensorPackage.M5_MOISTURE_SENSOR_DATA__TIMESTAMP:
				return timestamp != TIMESTAMP_EDEFAULT;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuilder result = new StringBuilder(super.toString());
		result.append(" (timestamp: ");
		result.append(timestamp);
		result.append(')');
		return result.toString();
	}

} //M5MoistureSensorDataImpl
