/**
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *      Ilenia Salvadori - initial API and implementation
 */
package org.gecko.mac.moisturesensor.impl;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;

import org.eclipse.emf.ecore.impl.EFactoryImpl;

import org.eclipse.emf.ecore.plugin.EcorePlugin;

import org.gecko.mac.moisturesensor.*;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model <b>Factory</b>.
 * <!-- end-user-doc -->
 * @generated
 */
public class MoistureSensorFactoryImpl extends EFactoryImpl implements MoistureSensorFactory {
	/**
	 * Creates the default factory implementation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static MoistureSensorFactory init() {
		try {
			MoistureSensorFactory theMoistureSensorFactory = (MoistureSensorFactory)EPackage.Registry.INSTANCE.getEFactory(MoistureSensorPackage.eNS_URI);
			if (theMoistureSensorFactory != null) {
				return theMoistureSensorFactory;
			}
		}
		catch (Exception exception) {
			EcorePlugin.INSTANCE.log(exception);
		}
		return new MoistureSensorFactoryImpl();
	}

	/**
	 * Creates an instance of the factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public MoistureSensorFactoryImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EObject create(EClass eClass) {
		switch (eClass.getClassifierID()) {
			case MoistureSensorPackage.ATOM_LITE: return createAtomLite();
			case MoistureSensorPackage.ATOM_LITE_OBJECT: return createAtomLiteObject();
			case MoistureSensorPackage.M5_MOISTURE_UPLINK: return createM5MoistureUplink();
			case MoistureSensorPackage.M5_MOISTURE_SENSOR_DATA: return createM5MoistureSensorData();
			case MoistureSensorPackage.M5_MOISTURE_READING: return createM5MoistureReading();
			case MoistureSensorPackage.M5_CALIBRATION_DATA: return createM5CalibrationData();
			case MoistureSensorPackage.ATOM_LITE_V2: return createAtomLiteV2();
			case MoistureSensorPackage.M5_MOISTURE_UPLINK_V2: return createM5MoistureUplinkV2();
			default:
				throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public AtomLite createAtomLite() {
		AtomLiteImpl atomLite = new AtomLiteImpl();
		return atomLite;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public AtomLiteObject createAtomLiteObject() {
		AtomLiteObjectImpl atomLiteObject = new AtomLiteObjectImpl();
		return atomLiteObject;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public M5MoistureUplink createM5MoistureUplink() {
		M5MoistureUplinkImpl m5MoistureUplink = new M5MoistureUplinkImpl();
		return m5MoistureUplink;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public M5MoistureSensorData createM5MoistureSensorData() {
		M5MoistureSensorDataImpl m5MoistureSensorData = new M5MoistureSensorDataImpl();
		return m5MoistureSensorData;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public M5MoistureReading createM5MoistureReading() {
		M5MoistureReadingImpl m5MoistureReading = new M5MoistureReadingImpl();
		return m5MoistureReading;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public M5CalibrationData createM5CalibrationData() {
		M5CalibrationDataImpl m5CalibrationData = new M5CalibrationDataImpl();
		return m5CalibrationData;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public AtomLiteV2 createAtomLiteV2() {
		AtomLiteV2Impl atomLiteV2 = new AtomLiteV2Impl();
		return atomLiteV2;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public M5MoistureUplinkV2 createM5MoistureUplinkV2() {
		M5MoistureUplinkV2Impl m5MoistureUplinkV2 = new M5MoistureUplinkV2Impl();
		return m5MoistureUplinkV2;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public MoistureSensorPackage getMoistureSensorPackage() {
		return (MoistureSensorPackage)getEPackage();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @deprecated
	 * @generated
	 */
	@Deprecated
	public static MoistureSensorPackage getPackage() {
		return MoistureSensorPackage.eINSTANCE;
	}

} //MoistureSensorFactoryImpl
