/**
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *      Ilenia Salvadori - initial API and implementation
 */
package org.gecko.mac.moisturesensor.impl;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;

import org.eclipse.emf.ecore.impl.EPackageImpl;

import org.gecko.mac.lorawan.LoRaWANPackage;

import org.gecko.mac.moisturesensor.AtomLite;
import org.gecko.mac.moisturesensor.AtomLiteObject;
import org.gecko.mac.moisturesensor.AtomLiteV2;
import org.gecko.mac.moisturesensor.M5CalibrationData;
import org.gecko.mac.moisturesensor.M5MoistureReading;
import org.gecko.mac.moisturesensor.M5MoistureSensorData;
import org.gecko.mac.moisturesensor.M5MoistureUplink;
import org.gecko.mac.moisturesensor.M5MoistureUplinkV2;
import org.gecko.mac.moisturesensor.MoistureSensorFactory;
import org.gecko.mac.moisturesensor.MoistureSensorPackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model <b>Package</b>.
 * <!-- end-user-doc -->
 * @generated
 */
public class MoistureSensorPackageImpl extends EPackageImpl implements MoistureSensorPackage {
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass atomLiteEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass atomLiteObjectEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass m5MoistureUplinkEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass m5MoistureSensorDataEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass m5MoistureReadingEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass m5CalibrationDataEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass atomLiteV2EClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass m5MoistureUplinkV2EClass = null;

	/**
	 * Creates an instance of the model <b>Package</b>, registered with
	 * {@link org.eclipse.emf.ecore.EPackage.Registry EPackage.Registry} by the package
	 * package URI value.
	 * <p>Note: the correct way to create the package is via the static
	 * factory method {@link #init init()}, which also performs
	 * initialization of the package, or returns the registered package,
	 * if one already exists.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.emf.ecore.EPackage.Registry
	 * @see org.gecko.mac.moisturesensor.MoistureSensorPackage#eNS_URI
	 * @see #init()
	 * @generated
	 */
	private MoistureSensorPackageImpl() {
		super(eNS_URI, MoistureSensorFactory.eINSTANCE);
	}
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private static boolean isInited = false;

	/**
	 * Creates, registers, and initializes the <b>Package</b> for this model, and for any others upon which it depends.
	 *
	 * <p>This method is used to initialize {@link MoistureSensorPackage#eINSTANCE} when that field is accessed.
	 * Clients should not invoke it directly. Instead, they should simply access that field to obtain the package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #eNS_URI
	 * @see #createPackageContents()
	 * @see #initializePackageContents()
	 * @generated
	 */
	public static MoistureSensorPackage init() {
		if (isInited) return (MoistureSensorPackage)EPackage.Registry.INSTANCE.getEPackage(MoistureSensorPackage.eNS_URI);

		// Obtain or create and register package
		Object registeredMoistureSensorPackage = EPackage.Registry.INSTANCE.get(eNS_URI);
		MoistureSensorPackageImpl theMoistureSensorPackage = registeredMoistureSensorPackage instanceof MoistureSensorPackageImpl ? (MoistureSensorPackageImpl)registeredMoistureSensorPackage : new MoistureSensorPackageImpl();

		isInited = true;

		// Initialize simple dependencies
		LoRaWANPackage.eINSTANCE.eClass();

		// Create package meta-data objects
		theMoistureSensorPackage.createPackageContents();

		// Initialize created meta-data
		theMoistureSensorPackage.initializePackageContents();

		// Mark meta-data to indicate it can't be changed
		theMoistureSensorPackage.freeze();

		// Update the registry and return the package
		EPackage.Registry.INSTANCE.put(MoistureSensorPackage.eNS_URI, theMoistureSensorPackage);
		return theMoistureSensorPackage;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getAtomLite() {
		return atomLiteEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getAtomLite_Object() {
		return (EReference)atomLiteEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getAtomLiteObject() {
		return atomLiteObjectEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getAtomLiteObject_Timestamp() {
		return (EAttribute)atomLiteObjectEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getAtomLiteObject_MoistureRaw() {
		return (EAttribute)atomLiteObjectEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getAtomLiteObject_MoisturePercent() {
		return (EAttribute)atomLiteObjectEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getAtomLiteObject_CalDry() {
		return (EAttribute)atomLiteObjectEClass.getEStructuralFeatures().get(3);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getAtomLiteObject_CalWet() {
		return (EAttribute)atomLiteObjectEClass.getEStructuralFeatures().get(4);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getM5MoistureUplink() {
		return m5MoistureUplinkEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getM5MoistureUplink_Object() {
		return (EReference)m5MoistureUplinkEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getM5MoistureSensorData() {
		return m5MoistureSensorDataEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getM5MoistureSensorData_Moisture() {
		return (EReference)m5MoistureSensorDataEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getM5MoistureSensorData_Cal() {
		return (EReference)m5MoistureSensorDataEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getM5MoistureSensorData_Timestamp() {
		return (EAttribute)m5MoistureSensorDataEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getM5MoistureReading() {
		return m5MoistureReadingEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getM5MoistureReading_Percent() {
		return (EAttribute)m5MoistureReadingEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getM5MoistureReading_Raw() {
		return (EAttribute)m5MoistureReadingEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getM5CalibrationData() {
		return m5CalibrationDataEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getM5CalibrationData_Dry() {
		return (EAttribute)m5CalibrationDataEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getM5CalibrationData_Wet() {
		return (EAttribute)m5CalibrationDataEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getAtomLiteV2() {
		return atomLiteV2EClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getAtomLiteV2_Object() {
		return (EReference)atomLiteV2EClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getM5MoistureUplinkV2() {
		return m5MoistureUplinkV2EClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getM5MoistureUplinkV2_Object() {
		return (EReference)m5MoistureUplinkV2EClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public MoistureSensorFactory getMoistureSensorFactory() {
		return (MoistureSensorFactory)getEFactoryInstance();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private boolean isCreated = false;

	/**
	 * Creates the meta-model objects for the package.  This method is
	 * guarded to have no affect on any invocation but its first.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void createPackageContents() {
		if (isCreated) return;
		isCreated = true;

		// Create classes and their features
		atomLiteEClass = createEClass(ATOM_LITE);
		createEReference(atomLiteEClass, ATOM_LITE__OBJECT);

		atomLiteObjectEClass = createEClass(ATOM_LITE_OBJECT);
		createEAttribute(atomLiteObjectEClass, ATOM_LITE_OBJECT__TIMESTAMP);
		createEAttribute(atomLiteObjectEClass, ATOM_LITE_OBJECT__MOISTURE_RAW);
		createEAttribute(atomLiteObjectEClass, ATOM_LITE_OBJECT__MOISTURE_PERCENT);
		createEAttribute(atomLiteObjectEClass, ATOM_LITE_OBJECT__CAL_DRY);
		createEAttribute(atomLiteObjectEClass, ATOM_LITE_OBJECT__CAL_WET);

		m5MoistureUplinkEClass = createEClass(M5_MOISTURE_UPLINK);
		createEReference(m5MoistureUplinkEClass, M5_MOISTURE_UPLINK__OBJECT);

		m5MoistureSensorDataEClass = createEClass(M5_MOISTURE_SENSOR_DATA);
		createEReference(m5MoistureSensorDataEClass, M5_MOISTURE_SENSOR_DATA__MOISTURE);
		createEReference(m5MoistureSensorDataEClass, M5_MOISTURE_SENSOR_DATA__CAL);
		createEAttribute(m5MoistureSensorDataEClass, M5_MOISTURE_SENSOR_DATA__TIMESTAMP);

		m5MoistureReadingEClass = createEClass(M5_MOISTURE_READING);
		createEAttribute(m5MoistureReadingEClass, M5_MOISTURE_READING__PERCENT);
		createEAttribute(m5MoistureReadingEClass, M5_MOISTURE_READING__RAW);

		m5CalibrationDataEClass = createEClass(M5_CALIBRATION_DATA);
		createEAttribute(m5CalibrationDataEClass, M5_CALIBRATION_DATA__DRY);
		createEAttribute(m5CalibrationDataEClass, M5_CALIBRATION_DATA__WET);

		atomLiteV2EClass = createEClass(ATOM_LITE_V2);
		createEReference(atomLiteV2EClass, ATOM_LITE_V2__OBJECT);

		m5MoistureUplinkV2EClass = createEClass(M5_MOISTURE_UPLINK_V2);
		createEReference(m5MoistureUplinkV2EClass, M5_MOISTURE_UPLINK_V2__OBJECT);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private boolean isInitialized = false;

	/**
	 * Complete the initialization of the package and its meta-model.  This
	 * method is guarded to have no affect on any invocation but its first.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void initializePackageContents() {
		if (isInitialized) return;
		isInitialized = true;

		// Initialize package
		setName(eNAME);
		setNsPrefix(eNS_PREFIX);
		setNsURI(eNS_URI);

		// Obtain other dependent packages
		LoRaWANPackage theLoRaWANPackage = (LoRaWANPackage)EPackage.Registry.INSTANCE.getEPackage(LoRaWANPackage.eNS_URI);

		// Create type parameters

		// Set bounds for type parameters

		// Add supertypes to classes
		atomLiteEClass.getESuperTypes().add(theLoRaWANPackage.getUplinkMessage());
		m5MoistureUplinkEClass.getESuperTypes().add(theLoRaWANPackage.getUplinkMessage());
		atomLiteV2EClass.getESuperTypes().add(theLoRaWANPackage.getUplinkMessage());
		m5MoistureUplinkV2EClass.getESuperTypes().add(theLoRaWANPackage.getUplinkMessage());

		// Initialize classes, features, and operations; add parameters
		initEClass(atomLiteEClass, AtomLite.class, "AtomLite", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getAtomLite_Object(), this.getAtomLiteObject(), null, "object", null, 0, 1, AtomLite.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(atomLiteObjectEClass, AtomLiteObject.class, "AtomLiteObject", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getAtomLiteObject_Timestamp(), ecorePackage.getEString(), "timestamp", null, 0, 1, AtomLiteObject.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getAtomLiteObject_MoistureRaw(), ecorePackage.getEFloat(), "moistureRaw", null, 0, 1, AtomLiteObject.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getAtomLiteObject_MoisturePercent(), ecorePackage.getEFloat(), "moisturePercent", null, 0, 1, AtomLiteObject.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getAtomLiteObject_CalDry(), ecorePackage.getEFloat(), "calDry", null, 0, 1, AtomLiteObject.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getAtomLiteObject_CalWet(), ecorePackage.getEFloat(), "calWet", null, 0, 1, AtomLiteObject.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(m5MoistureUplinkEClass, M5MoistureUplink.class, "M5MoistureUplink", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getM5MoistureUplink_Object(), this.getM5MoistureSensorData(), null, "object", null, 1, 1, M5MoistureUplink.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(m5MoistureSensorDataEClass, M5MoistureSensorData.class, "M5MoistureSensorData", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getM5MoistureSensorData_Moisture(), this.getM5MoistureReading(), null, "moisture", null, 1, 1, M5MoistureSensorData.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getM5MoistureSensorData_Cal(), this.getM5CalibrationData(), null, "cal", null, 1, 1, M5MoistureSensorData.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getM5MoistureSensorData_Timestamp(), ecorePackage.getEDouble(), "timestamp", null, 0, 1, M5MoistureSensorData.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(m5MoistureReadingEClass, M5MoistureReading.class, "M5MoistureReading", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getM5MoistureReading_Percent(), ecorePackage.getEInt(), "percent", null, 0, 1, M5MoistureReading.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getM5MoistureReading_Raw(), ecorePackage.getEInt(), "raw", null, 0, 1, M5MoistureReading.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(m5CalibrationDataEClass, M5CalibrationData.class, "M5CalibrationData", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getM5CalibrationData_Dry(), ecorePackage.getEInt(), "dry", null, 0, 1, M5CalibrationData.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getM5CalibrationData_Wet(), ecorePackage.getEInt(), "wet", null, 0, 1, M5CalibrationData.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(atomLiteV2EClass, AtomLiteV2.class, "AtomLiteV2", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getAtomLiteV2_Object(), this.getAtomLiteObject(), null, "object", null, 0, 1, AtomLiteV2.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(m5MoistureUplinkV2EClass, M5MoistureUplinkV2.class, "M5MoistureUplinkV2", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getM5MoistureUplinkV2_Object(), this.getM5MoistureSensorData(), null, "object", null, 1, 1, M5MoistureUplinkV2.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		// Create resource
		createResource(eNS_URI);

		// Create annotations
		// Version
		createVersionAnnotations();
		// http://www.eclipse.org/emf/2002/GenModel
		createGenModelAnnotations();
		// codec.type
		createCodecAnnotations();
		// http:///org/eclipse/emf/ecore/util/ExtendedMetaData
		createExtendedMetaDataAnnotations();
	}

	/**
	 * Initializes the annotations for <b>Version</b>.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void createVersionAnnotations() {
		String source = "Version";
		addAnnotation
		  (this,
		   source,
		   new String[] {
			   "value", "1.0"
		   });
	}

	/**
	 * Initializes the annotations for <b>http://www.eclipse.org/emf/2002/GenModel</b>.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void createGenModelAnnotations() {
		String source = "http://www.eclipse.org/emf/2002/GenModel";
		addAnnotation
		  (this,
		   source,
		   new String[] {
			   "modelName", "MoistureSensor",
			   "copyrightText", "Copyright (c) 2012 - 2025 Data In Motion and others.\nAll rights reserved.\n\nThis program and the accompanying materials are made\navailable under the terms of the Eclipse Public License 2.0\nwhich is available at https://www.eclipse.org/legal/epl-2.0/\n\nSPDX-License-Identifier: EPL-2.0\n\nContributors:\n     Ilenia Salvadori - initial API and implementation",
			   "resource", "XMI",
			   "oSGiCompatible", "true",
			   "basePackage", "org.gecko.mac"
		   });
		addAnnotation
		  (getM5MoistureUplink_Object(),
		   source,
		   new String[] {
			   "documentation", "Decoded sensor payload containing moisture readings and calibration data"
		   });
		addAnnotation
		  (m5MoistureSensorDataEClass,
		   source,
		   new String[] {
			   "documentation", "Container for moisture sensor data including readings, calibration, and timestamp"
		   });
		addAnnotation
		  (getM5MoistureSensorData_Moisture(),
		   source,
		   new String[] {
			   "documentation", "Current moisture measurement with percentage and raw ADC value"
		   });
		addAnnotation
		  (getM5MoistureSensorData_Cal(),
		   source,
		   new String[] {
			   "documentation", "Calibration values for dry and wet soil conditions"
		   });
		addAnnotation
		  (getM5MoistureSensorData_Timestamp(),
		   source,
		   new String[] {
			   "documentation", "Sensor timestamp in seconds since device boot"
		   });
		addAnnotation
		  (m5MoistureReadingEClass,
		   source,
		   new String[] {
			   "documentation", "Moisture measurement data with calibrated percentage and raw ADC value"
		   });
		addAnnotation
		  (getM5MoistureReading_Percent(),
		   source,
		   new String[] {
			   "documentation", "Calibrated moisture percentage (0-100%)"
		   });
		addAnnotation
		  (getM5MoistureReading_Raw(),
		   source,
		   new String[] {
			   "documentation", "Raw ADC reading from moisture sensor"
		   });
		addAnnotation
		  (m5CalibrationDataEClass,
		   source,
		   new String[] {
			   "documentation", "Calibration reference values for converting raw ADC readings to percentage"
		   });
		addAnnotation
		  (getM5CalibrationData_Dry(),
		   source,
		   new String[] {
			   "documentation", "Raw ADC value for completely dry soil (0% moisture)"
		   });
		addAnnotation
		  (getM5CalibrationData_Wet(),
		   source,
		   new String[] {
			   "documentation", "Raw ADC value for completely wet soil (100% moisture)"
		   });
		addAnnotation
		  (getM5MoistureUplinkV2_Object(),
		   source,
		   new String[] {
			   "documentation", "Decoded sensor payload containing moisture readings and calibration data"
		   });
	}

	/**
	 * Initializes the annotations for <b>codec.type</b>.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void createCodecAnnotations() {
		String source = "codec.type";
		addAnnotation
		  (atomLiteEClass,
		   source,
		   new String[] {
			   "M5AtomLite", "AtomLite"
		   });
		addAnnotation
		  (m5MoistureUplinkEClass,
		   source,
		   new String[] {
			   "M5MoistureV1", "M5MoistureUplink"
		   });
		addAnnotation
		  (atomLiteV2EClass,
		   source,
		   new String[] {
			   "M5AtomLiteV2", "AtomLiteV2"
		   });
		addAnnotation
		  (m5MoistureUplinkV2EClass,
		   source,
		   new String[] {
			   "M5MoistureV2", "M5MoistureUplinkV2"
		   });
	}

	/**
	 * Initializes the annotations for <b>http:///org/eclipse/emf/ecore/util/ExtendedMetaData</b>.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void createExtendedMetaDataAnnotations() {
		String source = "http:///org/eclipse/emf/ecore/util/ExtendedMetaData";
		addAnnotation
		  (getAtomLiteObject_MoistureRaw(),
		   source,
		   new String[] {
			   "name", "moisture_raw"
		   });
		addAnnotation
		  (getAtomLiteObject_MoisturePercent(),
		   source,
		   new String[] {
			   "name", "moisture_percent"
		   });
		addAnnotation
		  (getAtomLiteObject_CalDry(),
		   source,
		   new String[] {
			   "name", "cal_dry"
		   });
		addAnnotation
		  (getAtomLiteObject_CalWet(),
		   source,
		   new String[] {
			   "name", "cal_wet"
		   });
	}

} //MoistureSensorPackageImpl
