/**
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *      Ilenia Salvadori - initial API and implementation
 */
package org.gecko.mac.moisturesensor.util;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;

import org.eclipse.emf.common.notify.impl.AdapterFactoryImpl;

import org.eclipse.emf.ecore.EObject;

import org.gecko.mac.lorawan.UplinkMessage;

import org.gecko.mac.moisturesensor.*;

/**
 * <!-- begin-user-doc -->
 * The <b>Adapter Factory</b> for the model.
 * It provides an adapter <code>createXXX</code> method for each class of the model.
 * <!-- end-user-doc -->
 * @see org.gecko.mac.moisturesensor.MoistureSensorPackage
 * @generated
 */
public class MoistureSensorAdapterFactory extends AdapterFactoryImpl {
	/**
	 * The cached model package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected static MoistureSensorPackage modelPackage;

	/**
	 * Creates an instance of the adapter factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public MoistureSensorAdapterFactory() {
		if (modelPackage == null) {
			modelPackage = MoistureSensorPackage.eINSTANCE;
		}
	}

	/**
	 * Returns whether this factory is applicable for the type of the object.
	 * <!-- begin-user-doc -->
	 * This implementation returns <code>true</code> if the object is either the model's package or is an instance object of the model.
	 * <!-- end-user-doc -->
	 * @return whether this factory is applicable for the type of the object.
	 * @generated
	 */
	@Override
	public boolean isFactoryForType(Object object) {
		if (object == modelPackage) {
			return true;
		}
		if (object instanceof EObject) {
			return ((EObject)object).eClass().getEPackage() == modelPackage;
		}
		return false;
	}

	/**
	 * The switch that delegates to the <code>createXXX</code> methods.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected MoistureSensorSwitch<Adapter> modelSwitch =
		new MoistureSensorSwitch<Adapter>() {
			@Override
			public Adapter caseAtomLite(AtomLite object) {
				return createAtomLiteAdapter();
			}
			@Override
			public Adapter caseAtomLiteObject(AtomLiteObject object) {
				return createAtomLiteObjectAdapter();
			}
			@Override
			public Adapter caseM5MoistureUplink(M5MoistureUplink object) {
				return createM5MoistureUplinkAdapter();
			}
			@Override
			public Adapter caseM5MoistureSensorData(M5MoistureSensorData object) {
				return createM5MoistureSensorDataAdapter();
			}
			@Override
			public Adapter caseM5MoistureReading(M5MoistureReading object) {
				return createM5MoistureReadingAdapter();
			}
			@Override
			public Adapter caseM5CalibrationData(M5CalibrationData object) {
				return createM5CalibrationDataAdapter();
			}
			@Override
			public Adapter caseAtomLiteV2(AtomLiteV2 object) {
				return createAtomLiteV2Adapter();
			}
			@Override
			public Adapter caseM5MoistureUplinkV2(M5MoistureUplinkV2 object) {
				return createM5MoistureUplinkV2Adapter();
			}
			@Override
			public Adapter caseUplinkMessage(UplinkMessage object) {
				return createUplinkMessageAdapter();
			}
			@Override
			public Adapter defaultCase(EObject object) {
				return createEObjectAdapter();
			}
		};

	/**
	 * Creates an adapter for the <code>target</code>.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param target the object to adapt.
	 * @return the adapter for the <code>target</code>.
	 * @generated
	 */
	@Override
	public Adapter createAdapter(Notifier target) {
		return modelSwitch.doSwitch((EObject)target);
	}


	/**
	 * Creates a new adapter for an object of class '{@link org.gecko.mac.moisturesensor.AtomLite <em>Atom Lite</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.gecko.mac.moisturesensor.AtomLite
	 * @generated
	 */
	public Adapter createAtomLiteAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.gecko.mac.moisturesensor.AtomLiteObject <em>Atom Lite Object</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.gecko.mac.moisturesensor.AtomLiteObject
	 * @generated
	 */
	public Adapter createAtomLiteObjectAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.gecko.mac.moisturesensor.M5MoistureUplink <em>M5 Moisture Uplink</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.gecko.mac.moisturesensor.M5MoistureUplink
	 * @generated
	 */
	public Adapter createM5MoistureUplinkAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.gecko.mac.moisturesensor.M5MoistureSensorData <em>M5 Moisture Sensor Data</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.gecko.mac.moisturesensor.M5MoistureSensorData
	 * @generated
	 */
	public Adapter createM5MoistureSensorDataAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.gecko.mac.moisturesensor.M5MoistureReading <em>M5 Moisture Reading</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.gecko.mac.moisturesensor.M5MoistureReading
	 * @generated
	 */
	public Adapter createM5MoistureReadingAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.gecko.mac.moisturesensor.M5CalibrationData <em>M5 Calibration Data</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.gecko.mac.moisturesensor.M5CalibrationData
	 * @generated
	 */
	public Adapter createM5CalibrationDataAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.gecko.mac.moisturesensor.AtomLiteV2 <em>Atom Lite V2</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.gecko.mac.moisturesensor.AtomLiteV2
	 * @generated
	 */
	public Adapter createAtomLiteV2Adapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.gecko.mac.moisturesensor.M5MoistureUplinkV2 <em>M5 Moisture Uplink V2</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.gecko.mac.moisturesensor.M5MoistureUplinkV2
	 * @generated
	 */
	public Adapter createM5MoistureUplinkV2Adapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.gecko.mac.lorawan.UplinkMessage <em>Uplink Message</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.gecko.mac.lorawan.UplinkMessage
	 * @generated
	 */
	public Adapter createUplinkMessageAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for the default case.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @generated
	 */
	public Adapter createEObjectAdapter() {
		return null;
	}

} //MoistureSensorAdapterFactory
