/**
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *      Ilenia Salvadori - initial API and implementation
 */
package org.gecko.mac.moisturesensor.util;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;

import org.eclipse.emf.ecore.util.Switch;

import org.gecko.mac.lorawan.UplinkMessage;

import org.gecko.mac.moisturesensor.*;

/**
 * <!-- begin-user-doc -->
 * The <b>Switch</b> for the model's inheritance hierarchy.
 * It supports the call {@link #doSwitch(EObject) doSwitch(object)}
 * to invoke the <code>caseXXX</code> method for each class of the model,
 * starting with the actual class of the object
 * and proceeding up the inheritance hierarchy
 * until a non-null result is returned,
 * which is the result of the switch.
 * <!-- end-user-doc -->
 * @see org.gecko.mac.moisturesensor.MoistureSensorPackage
 * @generated
 */
public class MoistureSensorSwitch<T> extends Switch<T> {
	/**
	 * The cached model package
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected static MoistureSensorPackage modelPackage;

	/**
	 * Creates an instance of the switch.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public MoistureSensorSwitch() {
		if (modelPackage == null) {
			modelPackage = MoistureSensorPackage.eINSTANCE;
		}
	}

	/**
	 * Checks whether this is a switch for the given package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param ePackage the package in question.
	 * @return whether this is a switch for the given package.
	 * @generated
	 */
	@Override
	protected boolean isSwitchFor(EPackage ePackage) {
		return ePackage == modelPackage;
	}

	/**
	 * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the first non-null result returned by a <code>caseXXX</code> call.
	 * @generated
	 */
	@Override
	protected T doSwitch(int classifierID, EObject theEObject) {
		switch (classifierID) {
			case MoistureSensorPackage.ATOM_LITE: {
				AtomLite atomLite = (AtomLite)theEObject;
				T result = caseAtomLite(atomLite);
				if (result == null) result = caseUplinkMessage(atomLite);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case MoistureSensorPackage.ATOM_LITE_OBJECT: {
				AtomLiteObject atomLiteObject = (AtomLiteObject)theEObject;
				T result = caseAtomLiteObject(atomLiteObject);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case MoistureSensorPackage.M5_MOISTURE_UPLINK: {
				M5MoistureUplink m5MoistureUplink = (M5MoistureUplink)theEObject;
				T result = caseM5MoistureUplink(m5MoistureUplink);
				if (result == null) result = caseUplinkMessage(m5MoistureUplink);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case MoistureSensorPackage.M5_MOISTURE_SENSOR_DATA: {
				M5MoistureSensorData m5MoistureSensorData = (M5MoistureSensorData)theEObject;
				T result = caseM5MoistureSensorData(m5MoistureSensorData);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case MoistureSensorPackage.M5_MOISTURE_READING: {
				M5MoistureReading m5MoistureReading = (M5MoistureReading)theEObject;
				T result = caseM5MoistureReading(m5MoistureReading);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case MoistureSensorPackage.M5_CALIBRATION_DATA: {
				M5CalibrationData m5CalibrationData = (M5CalibrationData)theEObject;
				T result = caseM5CalibrationData(m5CalibrationData);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case MoistureSensorPackage.ATOM_LITE_V2: {
				AtomLiteV2 atomLiteV2 = (AtomLiteV2)theEObject;
				T result = caseAtomLiteV2(atomLiteV2);
				if (result == null) result = caseUplinkMessage(atomLiteV2);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case MoistureSensorPackage.M5_MOISTURE_UPLINK_V2: {
				M5MoistureUplinkV2 m5MoistureUplinkV2 = (M5MoistureUplinkV2)theEObject;
				T result = caseM5MoistureUplinkV2(m5MoistureUplinkV2);
				if (result == null) result = caseUplinkMessage(m5MoistureUplinkV2);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			default: return defaultCase(theEObject);
		}
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Atom Lite</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Atom Lite</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseAtomLite(AtomLite object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Atom Lite Object</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Atom Lite Object</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseAtomLiteObject(AtomLiteObject object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>M5 Moisture Uplink</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>M5 Moisture Uplink</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseM5MoistureUplink(M5MoistureUplink object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>M5 Moisture Sensor Data</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>M5 Moisture Sensor Data</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseM5MoistureSensorData(M5MoistureSensorData object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>M5 Moisture Reading</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>M5 Moisture Reading</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseM5MoistureReading(M5MoistureReading object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>M5 Calibration Data</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>M5 Calibration Data</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseM5CalibrationData(M5CalibrationData object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Atom Lite V2</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Atom Lite V2</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseAtomLiteV2(AtomLiteV2 object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>M5 Moisture Uplink V2</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>M5 Moisture Uplink V2</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseM5MoistureUplinkV2(M5MoistureUplinkV2 object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Uplink Message</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Uplink Message</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseUplinkMessage(UplinkMessage object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>EObject</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch, but this is the last case anyway.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>EObject</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject)
	 * @generated
	 */
	@Override
	public T defaultCase(EObject object) {
		return null;
	}

} //MoistureSensorSwitch
