/**
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved. 
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *     Data In Motion - initial API and implementation
 */
package org.gecko.mac.mqtt.handler;

import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;

@ObjectClassDefinition(name = "Demo system sensor Configuration")
public @interface SensorConfig {
	String topic() default "airquality";

	String messagingServiceId() default "playertour";

	double longitude();

	double latitude();
	
	@AttributeDefinition(description = "In case of unknown sensor, we specify a parent EPackage URI for the sensor, to be used during AI generation")
	String parentSensorPackageURI();
	
	@AttributeDefinition(description = "Filter for ResourceSet reference. This might be needed in case we are using the parentSensorPackageURI and we have to find the EPackage from the ResourceSet")
	String resourceSet_target();
}