/**
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *      Mark Hoffmann - initial API and implementation
 */
package org.gecko.mac.order.impl;

import org.gecko.mac.order.OrderService;
import org.gecko.mac.order.UserService;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

/**
 * 
 * @author mark
 * @since 26.10.2025
 */
//@Component
public class OrderComponent {
	
	@Reference
	private OrderService os;
	@Reference
	private UserService us;
	
	@Activate
	public void activate() {
		System.out.println("Activate OrderComponent");
		String user = us.createUser("Tester", "Emil");
		String orderId = os.getOrderDetails("1234");
		System.out.println("Got order for '" + user + "' with id: " + orderId);
	}

}
