/**
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved. 
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *     Data In Motion - initial API and implementation
 */
package org.gecko.mac.order.impl;

import org.gecko.mac.order.OrderService;
import org.osgi.service.component.annotations.Component;

/**
 * 
 * @author mark
 * @since 26.10.2025
 */
@Component(property = "audit.me=true")
public class OrderServiceImpl implements OrderService {

	/* 
	 * (non-Javadoc)
	 * @see org.gecko.mac.audit.OrderService#getOrderDetails(java.lang.String)
	 */
	@Override
	public String getOrderDetails(String orderId) {
		return "DETAIL-" + orderId;
	}

	/* 
	 * (non-Javadoc)
	 * @see org.gecko.mac.audit.OrderService#getUser(java.lang.String)
	 */
	@Override
	public String getUser(String orderId) {
		return "ORDER-USER-" + orderId;
	}

	@Override
	public String processOrder(String orderId) {
		// Simulate some processing time
		try {
			Thread.sleep(50);
		} catch (InterruptedException e) {
			Thread.currentThread().interrupt();
		}
		return "PROCESSED-" + orderId;
	}

}
