/**
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved. 
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *     Data In Motion - initial API and implementation
 */
package org.gecko.mac.order.impl;

import org.gecko.mac.order.UserService;
import org.osgi.service.component.annotations.Component;

/**
 * 
 * @author mark
 * @since 26.10.2025
 */
@Component(property = "audit.me=true")
public class UserServiceImpl implements UserService {

	/* 
	 * (non-Javadoc)
	 * @see org.gecko.mac.audit.UserService#createUser(java.lang.String, java.lang.String)
	 */
	@Override
	public String createUser(String lastName, String firstName) {
		return lastName + ", " + firstName;
	}

	/* 
	 * (non-Javadoc)
	 * @see org.gecko.mac.audit.UserService#getUser(java.lang.String)
	 */
	@Override
	public String getUser(String userId) {
		return "user-" + userId;
	}

}
