/*
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *      Ilenia Salvadori - initial API and implementation
 */
package org.gecko.mac.player;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EObject;

import org.osgi.annotation.versioning.ProviderType;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Player</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link org.gecko.mac.player.Player#getId <em>Id</em>}</li>
 *   <li>{@link org.gecko.mac.player.Player#getMembershipId <em>Membership Id</em>}</li>
 *   <li>{@link org.gecko.mac.player.Player#getFirstName <em>First Name</em>}</li>
 *   <li>{@link org.gecko.mac.player.Player#getLastName <em>Last Name</em>}</li>
 *   <li>{@link org.gecko.mac.player.Player#getContacts <em>Contacts</em>}</li>
 *   <li>{@link org.gecko.mac.player.Player#getScorecards <em>Scorecards</em>}</li>
 * </ul>
 *
 * @see org.gecko.mac.player.PlayerPackage#getPlayer()
 * @model
 * @generated
 */
@ProviderType
public interface Player extends EObject {
	/**
	 * Returns the value of the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Id</em>' attribute.
	 * @see #setId(String)
	 * @see org.gecko.mac.player.PlayerPackage#getPlayer_Id()
	 * @model id="true"
	 * @generated
	 */
	String getId();

	/**
	 * Sets the value of the '{@link org.gecko.mac.player.Player#getId <em>Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Id</em>' attribute.
	 * @see #getId()
	 * @generated
	 */
	void setId(String value);

	/**
	 * Returns the value of the '<em><b>Membership Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Membership Id</em>' attribute.
	 * @see #setMembershipId(String)
	 * @see org.gecko.mac.player.PlayerPackage#getPlayer_MembershipId()
	 * @model
	 * @generated
	 */
	String getMembershipId();

	/**
	 * Sets the value of the '{@link org.gecko.mac.player.Player#getMembershipId <em>Membership Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Membership Id</em>' attribute.
	 * @see #getMembershipId()
	 * @generated
	 */
	void setMembershipId(String value);

	/**
	 * Returns the value of the '<em><b>First Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>First Name</em>' attribute.
	 * @see #setFirstName(String)
	 * @see org.gecko.mac.player.PlayerPackage#getPlayer_FirstName()
	 * @model
	 * @generated
	 */
	String getFirstName();

	/**
	 * Sets the value of the '{@link org.gecko.mac.player.Player#getFirstName <em>First Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>First Name</em>' attribute.
	 * @see #getFirstName()
	 * @generated
	 */
	void setFirstName(String value);

	/**
	 * Returns the value of the '<em><b>Last Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Last Name</em>' attribute.
	 * @see #setLastName(String)
	 * @see org.gecko.mac.player.PlayerPackage#getPlayer_LastName()
	 * @model
	 * @generated
	 */
	String getLastName();

	/**
	 * Sets the value of the '{@link org.gecko.mac.player.Player#getLastName <em>Last Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Last Name</em>' attribute.
	 * @see #getLastName()
	 * @generated
	 */
	void setLastName(String value);

	/**
	 * Returns the value of the '<em><b>Contacts</b></em>' containment reference list.
	 * The list contents are of type {@link org.gecko.mac.player.Contact}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Contacts</em>' containment reference list.
	 * @see org.gecko.mac.player.PlayerPackage#getPlayer_Contacts()
	 * @model containment="true"
	 * @generated
	 */
	EList<Contact> getContacts();

	/**
	 * Returns the value of the '<em><b>Scorecards</b></em>' reference list.
	 * The list contents are of type {@link org.gecko.mac.player.PlayerScorecard}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Scorecards</em>' reference list.
	 * @see org.gecko.mac.player.PlayerPackage#getPlayer_Scorecards()
	 * @model
	 * @generated
	 */
	EList<PlayerScorecard> getScorecards();

} // Player
