/*
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *      Ilenia Salvadori - initial API and implementation
 */
package org.gecko.mac.player;


import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EReference;

import org.gecko.emf.osgi.annotation.provide.EPackage;

import org.osgi.annotation.versioning.ProviderType;

/**
 * <!-- begin-user-doc -->
 * The <b>Package</b> for the model.
 * It contains accessors for the meta objects to represent
 * <ul>
 *   <li>each class,</li>
 *   <li>each feature of each class,</li>
 *   <li>each operation of each class,</li>
 *   <li>each enum,</li>
 *   <li>and each data type</li>
 * </ul>
 * <!-- end-user-doc -->
 * @see org.gecko.mac.player.PlayerFactory
 * @model kind="package"
 *        annotation="Version value='1.0'"
 *        annotation="http://www.eclipse.org/emf/2002/GenModel oSGiCompatible='true' copyrightText='Copyright (c) 2012 - 2025 Data In Motion and others.\nAll rights reserved.\n\nThis program and the accompanying materials are made\navailable under the terms of the Eclipse Public License 2.0\nwhich is available at https://www.eclipse.org/legal/epl-2.0/\n\nSPDX-License-Identifier: EPL-2.0\n\nContributors:\n     Ilenia Salvadori - initial API and implementation' resource='XMI' basePackage='org.gecko.mac'"
 * @generated
 */
@ProviderType
@EPackage(uri = PlayerPackage.eNS_URI, genModel = "/model/player.genmodel", genModelSourceLocations = {"model/player.genmodel","org.gecko.mac.player.model/model/player.genmodel"}, ecore="/model/player.ecore", ecoreSourceLocations="/model/player.ecore")
public interface PlayerPackage extends org.eclipse.emf.ecore.EPackage {
	/**
	 * The package name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNAME = "player";

	/**
	 * The package namespace URI.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_URI = "player";

	/**
	 * The package namespace name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_PREFIX = "player";

	/**
	 * The singleton instance of the package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	PlayerPackage eINSTANCE = org.gecko.mac.player.impl.PlayerPackageImpl.init();

	/**
	 * The meta object id for the '{@link org.gecko.mac.player.impl.PlayerImpl <em>Player</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.gecko.mac.player.impl.PlayerImpl
	 * @see org.gecko.mac.player.impl.PlayerPackageImpl#getPlayer()
	 * @generated
	 */
	int PLAYER = 0;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PLAYER__ID = 0;

	/**
	 * The feature id for the '<em><b>Membership Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PLAYER__MEMBERSHIP_ID = 1;

	/**
	 * The feature id for the '<em><b>First Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PLAYER__FIRST_NAME = 2;

	/**
	 * The feature id for the '<em><b>Last Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PLAYER__LAST_NAME = 3;

	/**
	 * The feature id for the '<em><b>Contacts</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PLAYER__CONTACTS = 4;

	/**
	 * The feature id for the '<em><b>Scorecards</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PLAYER__SCORECARDS = 5;

	/**
	 * The number of structural features of the '<em>Player</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PLAYER_FEATURE_COUNT = 6;

	/**
	 * The number of operations of the '<em>Player</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PLAYER_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.gecko.mac.player.impl.PlayerScorecardImpl <em>Scorecard</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.gecko.mac.player.impl.PlayerScorecardImpl
	 * @see org.gecko.mac.player.impl.PlayerPackageImpl#getPlayerScorecard()
	 * @generated
	 */
	int PLAYER_SCORECARD = 1;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PLAYER_SCORECARD__ID = 0;

	/**
	 * The feature id for the '<em><b>Start</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PLAYER_SCORECARD__START = 1;

	/**
	 * The feature id for the '<em><b>End</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PLAYER_SCORECARD__END = 2;

	/**
	 * The feature id for the '<em><b>Course Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PLAYER_SCORECARD__COURSE_ID = 3;

	/**
	 * The feature id for the '<em><b>Ptr</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PLAYER_SCORECARD__PTR = 4;

	/**
	 * The feature id for the '<em><b>Ptb</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PLAYER_SCORECARD__PTB = 5;

	/**
	 * The number of structural features of the '<em>Scorecard</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PLAYER_SCORECARD_FEATURE_COUNT = 6;

	/**
	 * The number of operations of the '<em>Scorecard</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PLAYER_SCORECARD_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.gecko.mac.player.impl.ContactImpl <em>Contact</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.gecko.mac.player.impl.ContactImpl
	 * @see org.gecko.mac.player.impl.PlayerPackageImpl#getContact()
	 * @generated
	 */
	int CONTACT = 2;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTACT__TYPE = 0;

	/**
	 * The number of structural features of the '<em>Contact</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTACT_FEATURE_COUNT = 1;

	/**
	 * The number of operations of the '<em>Contact</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTACT_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.gecko.mac.player.ContactType <em>Contact Type</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.gecko.mac.player.ContactType
	 * @see org.gecko.mac.player.impl.PlayerPackageImpl#getContactType()
	 * @generated
	 */
	int CONTACT_TYPE = 3;


	/**
	 * Returns the meta object for class '{@link org.gecko.mac.player.Player <em>Player</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Player</em>'.
	 * @see org.gecko.mac.player.Player
	 * @generated
	 */
	EClass getPlayer();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.mac.player.Player#getId <em>Id</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Id</em>'.
	 * @see org.gecko.mac.player.Player#getId()
	 * @see #getPlayer()
	 * @generated
	 */
	EAttribute getPlayer_Id();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.mac.player.Player#getMembershipId <em>Membership Id</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Membership Id</em>'.
	 * @see org.gecko.mac.player.Player#getMembershipId()
	 * @see #getPlayer()
	 * @generated
	 */
	EAttribute getPlayer_MembershipId();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.mac.player.Player#getFirstName <em>First Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>First Name</em>'.
	 * @see org.gecko.mac.player.Player#getFirstName()
	 * @see #getPlayer()
	 * @generated
	 */
	EAttribute getPlayer_FirstName();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.mac.player.Player#getLastName <em>Last Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Last Name</em>'.
	 * @see org.gecko.mac.player.Player#getLastName()
	 * @see #getPlayer()
	 * @generated
	 */
	EAttribute getPlayer_LastName();

	/**
	 * Returns the meta object for the containment reference list '{@link org.gecko.mac.player.Player#getContacts <em>Contacts</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Contacts</em>'.
	 * @see org.gecko.mac.player.Player#getContacts()
	 * @see #getPlayer()
	 * @generated
	 */
	EReference getPlayer_Contacts();

	/**
	 * Returns the meta object for the reference list '{@link org.gecko.mac.player.Player#getScorecards <em>Scorecards</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Scorecards</em>'.
	 * @see org.gecko.mac.player.Player#getScorecards()
	 * @see #getPlayer()
	 * @generated
	 */
	EReference getPlayer_Scorecards();

	/**
	 * Returns the meta object for class '{@link org.gecko.mac.player.PlayerScorecard <em>Scorecard</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Scorecard</em>'.
	 * @see org.gecko.mac.player.PlayerScorecard
	 * @generated
	 */
	EClass getPlayerScorecard();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.mac.player.PlayerScorecard#getId <em>Id</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Id</em>'.
	 * @see org.gecko.mac.player.PlayerScorecard#getId()
	 * @see #getPlayerScorecard()
	 * @generated
	 */
	EAttribute getPlayerScorecard_Id();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.mac.player.PlayerScorecard#getStart <em>Start</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Start</em>'.
	 * @see org.gecko.mac.player.PlayerScorecard#getStart()
	 * @see #getPlayerScorecard()
	 * @generated
	 */
	EAttribute getPlayerScorecard_Start();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.mac.player.PlayerScorecard#getEnd <em>End</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>End</em>'.
	 * @see org.gecko.mac.player.PlayerScorecard#getEnd()
	 * @see #getPlayerScorecard()
	 * @generated
	 */
	EAttribute getPlayerScorecard_End();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.mac.player.PlayerScorecard#getCourseId <em>Course Id</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Course Id</em>'.
	 * @see org.gecko.mac.player.PlayerScorecard#getCourseId()
	 * @see #getPlayerScorecard()
	 * @generated
	 */
	EAttribute getPlayerScorecard_CourseId();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.mac.player.PlayerScorecard#getPtr <em>Ptr</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Ptr</em>'.
	 * @see org.gecko.mac.player.PlayerScorecard#getPtr()
	 * @see #getPlayerScorecard()
	 * @generated
	 */
	EAttribute getPlayerScorecard_Ptr();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.mac.player.PlayerScorecard#getPtb <em>Ptb</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Ptb</em>'.
	 * @see org.gecko.mac.player.PlayerScorecard#getPtb()
	 * @see #getPlayerScorecard()
	 * @generated
	 */
	EAttribute getPlayerScorecard_Ptb();

	/**
	 * Returns the meta object for class '{@link org.gecko.mac.player.Contact <em>Contact</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Contact</em>'.
	 * @see org.gecko.mac.player.Contact
	 * @generated
	 */
	EClass getContact();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.mac.player.Contact#getType <em>Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Type</em>'.
	 * @see org.gecko.mac.player.Contact#getType()
	 * @see #getContact()
	 * @generated
	 */
	EAttribute getContact_Type();

	/**
	 * Returns the meta object for enum '{@link org.gecko.mac.player.ContactType <em>Contact Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>Contact Type</em>'.
	 * @see org.gecko.mac.player.ContactType
	 * @generated
	 */
	EEnum getContactType();

	/**
	 * Returns the factory that creates the instances of the model.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the factory that creates the instances of the model.
	 * @generated
	 */
	PlayerFactory getPlayerFactory();

	/**
	 * <!-- begin-user-doc -->
	 * Defines literals for the meta objects that represent
	 * <ul>
	 *   <li>each class,</li>
	 *   <li>each feature of each class,</li>
	 *   <li>each operation of each class,</li>
	 *   <li>each enum,</li>
	 *   <li>and each data type</li>
	 * </ul>
	 * <!-- end-user-doc -->
	 * @generated
	 */
	interface Literals {
		/**
		 * The meta object literal for the '{@link org.gecko.mac.player.impl.PlayerImpl <em>Player</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.gecko.mac.player.impl.PlayerImpl
		 * @see org.gecko.mac.player.impl.PlayerPackageImpl#getPlayer()
		 * @generated
		 */
		EClass PLAYER = eINSTANCE.getPlayer();

		/**
		 * The meta object literal for the '<em><b>Id</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute PLAYER__ID = eINSTANCE.getPlayer_Id();

		/**
		 * The meta object literal for the '<em><b>Membership Id</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute PLAYER__MEMBERSHIP_ID = eINSTANCE.getPlayer_MembershipId();

		/**
		 * The meta object literal for the '<em><b>First Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute PLAYER__FIRST_NAME = eINSTANCE.getPlayer_FirstName();

		/**
		 * The meta object literal for the '<em><b>Last Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute PLAYER__LAST_NAME = eINSTANCE.getPlayer_LastName();

		/**
		 * The meta object literal for the '<em><b>Contacts</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference PLAYER__CONTACTS = eINSTANCE.getPlayer_Contacts();

		/**
		 * The meta object literal for the '<em><b>Scorecards</b></em>' reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference PLAYER__SCORECARDS = eINSTANCE.getPlayer_Scorecards();

		/**
		 * The meta object literal for the '{@link org.gecko.mac.player.impl.PlayerScorecardImpl <em>Scorecard</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.gecko.mac.player.impl.PlayerScorecardImpl
		 * @see org.gecko.mac.player.impl.PlayerPackageImpl#getPlayerScorecard()
		 * @generated
		 */
		EClass PLAYER_SCORECARD = eINSTANCE.getPlayerScorecard();

		/**
		 * The meta object literal for the '<em><b>Id</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute PLAYER_SCORECARD__ID = eINSTANCE.getPlayerScorecard_Id();

		/**
		 * The meta object literal for the '<em><b>Start</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute PLAYER_SCORECARD__START = eINSTANCE.getPlayerScorecard_Start();

		/**
		 * The meta object literal for the '<em><b>End</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute PLAYER_SCORECARD__END = eINSTANCE.getPlayerScorecard_End();

		/**
		 * The meta object literal for the '<em><b>Course Id</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute PLAYER_SCORECARD__COURSE_ID = eINSTANCE.getPlayerScorecard_CourseId();

		/**
		 * The meta object literal for the '<em><b>Ptr</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute PLAYER_SCORECARD__PTR = eINSTANCE.getPlayerScorecard_Ptr();

		/**
		 * The meta object literal for the '<em><b>Ptb</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute PLAYER_SCORECARD__PTB = eINSTANCE.getPlayerScorecard_Ptb();

		/**
		 * The meta object literal for the '{@link org.gecko.mac.player.impl.ContactImpl <em>Contact</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.gecko.mac.player.impl.ContactImpl
		 * @see org.gecko.mac.player.impl.PlayerPackageImpl#getContact()
		 * @generated
		 */
		EClass CONTACT = eINSTANCE.getContact();

		/**
		 * The meta object literal for the '<em><b>Type</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute CONTACT__TYPE = eINSTANCE.getContact_Type();

		/**
		 * The meta object literal for the '{@link org.gecko.mac.player.ContactType <em>Contact Type</em>}' enum.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.gecko.mac.player.ContactType
		 * @see org.gecko.mac.player.impl.PlayerPackageImpl#getContactType()
		 * @generated
		 */
		EEnum CONTACT_TYPE = eINSTANCE.getContactType();

	}

} //PlayerPackage
