/*
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *      Ilenia Salvadori - initial API and implementation
 */
package org.gecko.mac.player;

import java.util.Date;

import org.eclipse.emf.ecore.EObject;

import org.osgi.annotation.versioning.ProviderType;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Scorecard</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link org.gecko.mac.player.PlayerScorecard#getId <em>Id</em>}</li>
 *   <li>{@link org.gecko.mac.player.PlayerScorecard#getStart <em>Start</em>}</li>
 *   <li>{@link org.gecko.mac.player.PlayerScorecard#getEnd <em>End</em>}</li>
 *   <li>{@link org.gecko.mac.player.PlayerScorecard#getCourseId <em>Course Id</em>}</li>
 *   <li>{@link org.gecko.mac.player.PlayerScorecard#getPtr <em>Ptr</em>}</li>
 *   <li>{@link org.gecko.mac.player.PlayerScorecard#getPtb <em>Ptb</em>}</li>
 * </ul>
 *
 * @see org.gecko.mac.player.PlayerPackage#getPlayerScorecard()
 * @model
 * @generated
 */
@ProviderType
public interface PlayerScorecard extends EObject {
	/**
	 * Returns the value of the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Id</em>' attribute.
	 * @see #setId(String)
	 * @see org.gecko.mac.player.PlayerPackage#getPlayerScorecard_Id()
	 * @model id="true"
	 * @generated
	 */
	String getId();

	/**
	 * Sets the value of the '{@link org.gecko.mac.player.PlayerScorecard#getId <em>Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Id</em>' attribute.
	 * @see #getId()
	 * @generated
	 */
	void setId(String value);

	/**
	 * Returns the value of the '<em><b>Start</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Start</em>' attribute.
	 * @see #setStart(Date)
	 * @see org.gecko.mac.player.PlayerPackage#getPlayerScorecard_Start()
	 * @model required="true"
	 * @generated
	 */
	Date getStart();

	/**
	 * Sets the value of the '{@link org.gecko.mac.player.PlayerScorecard#getStart <em>Start</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Start</em>' attribute.
	 * @see #getStart()
	 * @generated
	 */
	void setStart(Date value);

	/**
	 * Returns the value of the '<em><b>End</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>End</em>' attribute.
	 * @see #setEnd(Date)
	 * @see org.gecko.mac.player.PlayerPackage#getPlayerScorecard_End()
	 * @model
	 * @generated
	 */
	Date getEnd();

	/**
	 * Sets the value of the '{@link org.gecko.mac.player.PlayerScorecard#getEnd <em>End</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>End</em>' attribute.
	 * @see #getEnd()
	 * @generated
	 */
	void setEnd(Date value);

	/**
	 * Returns the value of the '<em><b>Course Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Course Id</em>' attribute.
	 * @see #setCourseId(String)
	 * @see org.gecko.mac.player.PlayerPackage#getPlayerScorecard_CourseId()
	 * @model required="true"
	 * @generated
	 */
	String getCourseId();

	/**
	 * Sets the value of the '{@link org.gecko.mac.player.PlayerScorecard#getCourseId <em>Course Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Course Id</em>' attribute.
	 * @see #getCourseId()
	 * @generated
	 */
	void setCourseId(String value);

	/**
	 * Returns the value of the '<em><b>Ptr</b></em>' attribute.
	 * The default value is <code>"0"</code>.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * The player result
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Ptr</em>' attribute.
	 * @see #setPtr(int)
	 * @see org.gecko.mac.player.PlayerPackage#getPlayerScorecard_Ptr()
	 * @model default="0"
	 * @generated
	 */
	int getPtr();

	/**
	 * Sets the value of the '{@link org.gecko.mac.player.PlayerScorecard#getPtr <em>Ptr</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Ptr</em>' attribute.
	 * @see #getPtr()
	 * @generated
	 */
	void setPtr(int value);

	/**
	 * Returns the value of the '<em><b>Ptb</b></em>' attribute.
	 * The default value is <code>"0"</code>.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * The player balance
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Ptb</em>' attribute.
	 * @see #setPtb(int)
	 * @see org.gecko.mac.player.PlayerPackage#getPlayerScorecard_Ptb()
	 * @model default="0"
	 * @generated
	 */
	int getPtb();

	/**
	 * Sets the value of the '{@link org.gecko.mac.player.PlayerScorecard#getPtb <em>Ptb</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Ptb</em>' attribute.
	 * @see #getPtb()
	 * @generated
	 */
	void setPtb(int value);

} // PlayerScorecard
