/*
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *      Ilenia Salvadori - initial API and implementation
 */
package org.gecko.mac.player.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.MinimalEObjectImpl;

import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.EObjectResolvingEList;
import org.eclipse.emf.ecore.util.InternalEList;

import org.gecko.mac.player.Contact;
import org.gecko.mac.player.Player;
import org.gecko.mac.player.PlayerPackage;
import org.gecko.mac.player.PlayerScorecard;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Player</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link org.gecko.mac.player.impl.PlayerImpl#getId <em>Id</em>}</li>
 *   <li>{@link org.gecko.mac.player.impl.PlayerImpl#getMembershipId <em>Membership Id</em>}</li>
 *   <li>{@link org.gecko.mac.player.impl.PlayerImpl#getFirstName <em>First Name</em>}</li>
 *   <li>{@link org.gecko.mac.player.impl.PlayerImpl#getLastName <em>Last Name</em>}</li>
 *   <li>{@link org.gecko.mac.player.impl.PlayerImpl#getContacts <em>Contacts</em>}</li>
 *   <li>{@link org.gecko.mac.player.impl.PlayerImpl#getScorecards <em>Scorecards</em>}</li>
 * </ul>
 *
 * @generated
 */
public class PlayerImpl extends MinimalEObjectImpl.Container implements Player {
	/**
	 * The default value of the '{@link #getId() <em>Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getId()
	 * @generated
	 * @ordered
	 */
	protected static final String ID_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getId() <em>Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getId()
	 * @generated
	 * @ordered
	 */
	protected String id = ID_EDEFAULT;

	/**
	 * The default value of the '{@link #getMembershipId() <em>Membership Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getMembershipId()
	 * @generated
	 * @ordered
	 */
	protected static final String MEMBERSHIP_ID_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getMembershipId() <em>Membership Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getMembershipId()
	 * @generated
	 * @ordered
	 */
	protected String membershipId = MEMBERSHIP_ID_EDEFAULT;

	/**
	 * The default value of the '{@link #getFirstName() <em>First Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getFirstName()
	 * @generated
	 * @ordered
	 */
	protected static final String FIRST_NAME_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getFirstName() <em>First Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getFirstName()
	 * @generated
	 * @ordered
	 */
	protected String firstName = FIRST_NAME_EDEFAULT;

	/**
	 * The default value of the '{@link #getLastName() <em>Last Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getLastName()
	 * @generated
	 * @ordered
	 */
	protected static final String LAST_NAME_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getLastName() <em>Last Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getLastName()
	 * @generated
	 * @ordered
	 */
	protected String lastName = LAST_NAME_EDEFAULT;

	/**
	 * The cached value of the '{@link #getContacts() <em>Contacts</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getContacts()
	 * @generated
	 * @ordered
	 */
	protected EList<Contact> contacts;

	/**
	 * The cached value of the '{@link #getScorecards() <em>Scorecards</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getScorecards()
	 * @generated
	 * @ordered
	 */
	protected EList<PlayerScorecard> scorecards;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected PlayerImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return PlayerPackage.Literals.PLAYER;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getId() {
		return id;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setId(String newId) {
		String oldId = id;
		id = newId;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, PlayerPackage.PLAYER__ID, oldId, id));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getMembershipId() {
		return membershipId;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setMembershipId(String newMembershipId) {
		String oldMembershipId = membershipId;
		membershipId = newMembershipId;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, PlayerPackage.PLAYER__MEMBERSHIP_ID, oldMembershipId, membershipId));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getFirstName() {
		return firstName;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setFirstName(String newFirstName) {
		String oldFirstName = firstName;
		firstName = newFirstName;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, PlayerPackage.PLAYER__FIRST_NAME, oldFirstName, firstName));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getLastName() {
		return lastName;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setLastName(String newLastName) {
		String oldLastName = lastName;
		lastName = newLastName;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, PlayerPackage.PLAYER__LAST_NAME, oldLastName, lastName));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<Contact> getContacts() {
		if (contacts == null) {
			contacts = new EObjectContainmentEList<Contact>(Contact.class, this, PlayerPackage.PLAYER__CONTACTS);
		}
		return contacts;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<PlayerScorecard> getScorecards() {
		if (scorecards == null) {
			scorecards = new EObjectResolvingEList<PlayerScorecard>(PlayerScorecard.class, this, PlayerPackage.PLAYER__SCORECARDS);
		}
		return scorecards;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case PlayerPackage.PLAYER__CONTACTS:
				return ((InternalEList<?>)getContacts()).basicRemove(otherEnd, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case PlayerPackage.PLAYER__ID:
				return getId();
			case PlayerPackage.PLAYER__MEMBERSHIP_ID:
				return getMembershipId();
			case PlayerPackage.PLAYER__FIRST_NAME:
				return getFirstName();
			case PlayerPackage.PLAYER__LAST_NAME:
				return getLastName();
			case PlayerPackage.PLAYER__CONTACTS:
				return getContacts();
			case PlayerPackage.PLAYER__SCORECARDS:
				return getScorecards();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case PlayerPackage.PLAYER__ID:
				setId((String)newValue);
				return;
			case PlayerPackage.PLAYER__MEMBERSHIP_ID:
				setMembershipId((String)newValue);
				return;
			case PlayerPackage.PLAYER__FIRST_NAME:
				setFirstName((String)newValue);
				return;
			case PlayerPackage.PLAYER__LAST_NAME:
				setLastName((String)newValue);
				return;
			case PlayerPackage.PLAYER__CONTACTS:
				getContacts().clear();
				getContacts().addAll((Collection<? extends Contact>)newValue);
				return;
			case PlayerPackage.PLAYER__SCORECARDS:
				getScorecards().clear();
				getScorecards().addAll((Collection<? extends PlayerScorecard>)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case PlayerPackage.PLAYER__ID:
				setId(ID_EDEFAULT);
				return;
			case PlayerPackage.PLAYER__MEMBERSHIP_ID:
				setMembershipId(MEMBERSHIP_ID_EDEFAULT);
				return;
			case PlayerPackage.PLAYER__FIRST_NAME:
				setFirstName(FIRST_NAME_EDEFAULT);
				return;
			case PlayerPackage.PLAYER__LAST_NAME:
				setLastName(LAST_NAME_EDEFAULT);
				return;
			case PlayerPackage.PLAYER__CONTACTS:
				getContacts().clear();
				return;
			case PlayerPackage.PLAYER__SCORECARDS:
				getScorecards().clear();
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case PlayerPackage.PLAYER__ID:
				return ID_EDEFAULT == null ? id != null : !ID_EDEFAULT.equals(id);
			case PlayerPackage.PLAYER__MEMBERSHIP_ID:
				return MEMBERSHIP_ID_EDEFAULT == null ? membershipId != null : !MEMBERSHIP_ID_EDEFAULT.equals(membershipId);
			case PlayerPackage.PLAYER__FIRST_NAME:
				return FIRST_NAME_EDEFAULT == null ? firstName != null : !FIRST_NAME_EDEFAULT.equals(firstName);
			case PlayerPackage.PLAYER__LAST_NAME:
				return LAST_NAME_EDEFAULT == null ? lastName != null : !LAST_NAME_EDEFAULT.equals(lastName);
			case PlayerPackage.PLAYER__CONTACTS:
				return contacts != null && !contacts.isEmpty();
			case PlayerPackage.PLAYER__SCORECARDS:
				return scorecards != null && !scorecards.isEmpty();
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuilder result = new StringBuilder(super.toString());
		result.append(" (id: ");
		result.append(id);
		result.append(", membershipId: ");
		result.append(membershipId);
		result.append(", firstName: ");
		result.append(firstName);
		result.append(", lastName: ");
		result.append(lastName);
		result.append(')');
		return result.toString();
	}

} //PlayerImpl
