/*
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *      Ilenia Salvadori - initial API and implementation
 */
package org.gecko.mac.player.impl;

import java.util.Date;

import org.eclipse.emf.common.notify.Notification;

import org.eclipse.emf.ecore.EClass;

import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.MinimalEObjectImpl;

import org.gecko.mac.player.PlayerPackage;
import org.gecko.mac.player.PlayerScorecard;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Scorecard</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link org.gecko.mac.player.impl.PlayerScorecardImpl#getId <em>Id</em>}</li>
 *   <li>{@link org.gecko.mac.player.impl.PlayerScorecardImpl#getStart <em>Start</em>}</li>
 *   <li>{@link org.gecko.mac.player.impl.PlayerScorecardImpl#getEnd <em>End</em>}</li>
 *   <li>{@link org.gecko.mac.player.impl.PlayerScorecardImpl#getCourseId <em>Course Id</em>}</li>
 *   <li>{@link org.gecko.mac.player.impl.PlayerScorecardImpl#getPtr <em>Ptr</em>}</li>
 *   <li>{@link org.gecko.mac.player.impl.PlayerScorecardImpl#getPtb <em>Ptb</em>}</li>
 * </ul>
 *
 * @generated
 */
public class PlayerScorecardImpl extends MinimalEObjectImpl.Container implements PlayerScorecard {
	/**
	 * The default value of the '{@link #getId() <em>Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getId()
	 * @generated
	 * @ordered
	 */
	protected static final String ID_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getId() <em>Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getId()
	 * @generated
	 * @ordered
	 */
	protected String id = ID_EDEFAULT;

	/**
	 * The default value of the '{@link #getStart() <em>Start</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getStart()
	 * @generated
	 * @ordered
	 */
	protected static final Date START_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getStart() <em>Start</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getStart()
	 * @generated
	 * @ordered
	 */
	protected Date start = START_EDEFAULT;

	/**
	 * The default value of the '{@link #getEnd() <em>End</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getEnd()
	 * @generated
	 * @ordered
	 */
	protected static final Date END_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getEnd() <em>End</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getEnd()
	 * @generated
	 * @ordered
	 */
	protected Date end = END_EDEFAULT;

	/**
	 * The default value of the '{@link #getCourseId() <em>Course Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCourseId()
	 * @generated
	 * @ordered
	 */
	protected static final String COURSE_ID_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getCourseId() <em>Course Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCourseId()
	 * @generated
	 * @ordered
	 */
	protected String courseId = COURSE_ID_EDEFAULT;

	/**
	 * The default value of the '{@link #getPtr() <em>Ptr</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getPtr()
	 * @generated
	 * @ordered
	 */
	protected static final int PTR_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getPtr() <em>Ptr</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getPtr()
	 * @generated
	 * @ordered
	 */
	protected int ptr = PTR_EDEFAULT;

	/**
	 * The default value of the '{@link #getPtb() <em>Ptb</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getPtb()
	 * @generated
	 * @ordered
	 */
	protected static final int PTB_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getPtb() <em>Ptb</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getPtb()
	 * @generated
	 * @ordered
	 */
	protected int ptb = PTB_EDEFAULT;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected PlayerScorecardImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return PlayerPackage.Literals.PLAYER_SCORECARD;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getId() {
		return id;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setId(String newId) {
		String oldId = id;
		id = newId;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, PlayerPackage.PLAYER_SCORECARD__ID, oldId, id));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Date getStart() {
		return start;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setStart(Date newStart) {
		Date oldStart = start;
		start = newStart;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, PlayerPackage.PLAYER_SCORECARD__START, oldStart, start));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Date getEnd() {
		return end;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setEnd(Date newEnd) {
		Date oldEnd = end;
		end = newEnd;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, PlayerPackage.PLAYER_SCORECARD__END, oldEnd, end));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getCourseId() {
		return courseId;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setCourseId(String newCourseId) {
		String oldCourseId = courseId;
		courseId = newCourseId;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, PlayerPackage.PLAYER_SCORECARD__COURSE_ID, oldCourseId, courseId));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int getPtr() {
		return ptr;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setPtr(int newPtr) {
		int oldPtr = ptr;
		ptr = newPtr;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, PlayerPackage.PLAYER_SCORECARD__PTR, oldPtr, ptr));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int getPtb() {
		return ptb;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setPtb(int newPtb) {
		int oldPtb = ptb;
		ptb = newPtb;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, PlayerPackage.PLAYER_SCORECARD__PTB, oldPtb, ptb));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case PlayerPackage.PLAYER_SCORECARD__ID:
				return getId();
			case PlayerPackage.PLAYER_SCORECARD__START:
				return getStart();
			case PlayerPackage.PLAYER_SCORECARD__END:
				return getEnd();
			case PlayerPackage.PLAYER_SCORECARD__COURSE_ID:
				return getCourseId();
			case PlayerPackage.PLAYER_SCORECARD__PTR:
				return getPtr();
			case PlayerPackage.PLAYER_SCORECARD__PTB:
				return getPtb();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case PlayerPackage.PLAYER_SCORECARD__ID:
				setId((String)newValue);
				return;
			case PlayerPackage.PLAYER_SCORECARD__START:
				setStart((Date)newValue);
				return;
			case PlayerPackage.PLAYER_SCORECARD__END:
				setEnd((Date)newValue);
				return;
			case PlayerPackage.PLAYER_SCORECARD__COURSE_ID:
				setCourseId((String)newValue);
				return;
			case PlayerPackage.PLAYER_SCORECARD__PTR:
				setPtr((Integer)newValue);
				return;
			case PlayerPackage.PLAYER_SCORECARD__PTB:
				setPtb((Integer)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case PlayerPackage.PLAYER_SCORECARD__ID:
				setId(ID_EDEFAULT);
				return;
			case PlayerPackage.PLAYER_SCORECARD__START:
				setStart(START_EDEFAULT);
				return;
			case PlayerPackage.PLAYER_SCORECARD__END:
				setEnd(END_EDEFAULT);
				return;
			case PlayerPackage.PLAYER_SCORECARD__COURSE_ID:
				setCourseId(COURSE_ID_EDEFAULT);
				return;
			case PlayerPackage.PLAYER_SCORECARD__PTR:
				setPtr(PTR_EDEFAULT);
				return;
			case PlayerPackage.PLAYER_SCORECARD__PTB:
				setPtb(PTB_EDEFAULT);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case PlayerPackage.PLAYER_SCORECARD__ID:
				return ID_EDEFAULT == null ? id != null : !ID_EDEFAULT.equals(id);
			case PlayerPackage.PLAYER_SCORECARD__START:
				return START_EDEFAULT == null ? start != null : !START_EDEFAULT.equals(start);
			case PlayerPackage.PLAYER_SCORECARD__END:
				return END_EDEFAULT == null ? end != null : !END_EDEFAULT.equals(end);
			case PlayerPackage.PLAYER_SCORECARD__COURSE_ID:
				return COURSE_ID_EDEFAULT == null ? courseId != null : !COURSE_ID_EDEFAULT.equals(courseId);
			case PlayerPackage.PLAYER_SCORECARD__PTR:
				return ptr != PTR_EDEFAULT;
			case PlayerPackage.PLAYER_SCORECARD__PTB:
				return ptb != PTB_EDEFAULT;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuilder result = new StringBuilder(super.toString());
		result.append(" (id: ");
		result.append(id);
		result.append(", start: ");
		result.append(start);
		result.append(", end: ");
		result.append(end);
		result.append(", courseId: ");
		result.append(courseId);
		result.append(", ptr: ");
		result.append(ptr);
		result.append(", ptb: ");
		result.append(ptb);
		result.append(')');
		return result.toString();
	}

} //PlayerScorecardImpl
