/**
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved. 
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *     Mark Hoffmann - initial API and implementation
 */
package org.gecko.mac.rest;

import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;

import org.eclipse.fennec.apisix.api.ApiSixRoute;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ServiceScope;
import org.osgi.service.jakartars.whiteboard.annotations.RequireJakartarsWhiteboard;
import org.osgi.service.jakartars.whiteboard.propertytypes.JakartarsName;
import org.osgi.service.jakartars.whiteboard.propertytypes.JakartarsResource;
import org.osgi.service.servlet.whiteboard.annotations.RequireHttpWhiteboard;

/**
 * This is a Demo Resource for a Jakartars Whiteboard 
 * 
 * @since 1.0
 */
@RequireHttpWhiteboard
@RequireJakartarsWhiteboard
@JakartarsResource
@JakartarsName("v2-hello")
@Component(service = DemoResource2.class, enabled = true, scope = ServiceScope.PROTOTYPE)
@Path("/v2")
@ApiSixRoute(
    uri = "/demo2/*", 
    routeId = "demo2-v2",
    pathRewritePattern = {"^/demo2/(.*)$", "/mac/rest/v2/$1"}
)
public class DemoResource2 {

	/**
	 * Please check http://localhost:8181/mac/rest/hello-http-whiteboard
	 * @return
	 */
	@GET
	@Path("/hello")
	public String hello() {
		return "Hello3 World3!";
	}

}
